/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public abstract class AbstractCamouflageBlock
extends AbstractPneumaticCraftBlock {
    public static final ModelProperty<BlockState> CAMO_STATE = new ModelProperty();
    public static final ModelProperty<BlockGetter> BLOCK_ACCESS = new ModelProperty();
    public static final ModelProperty<BlockPos> BLOCK_POS = new ModelProperty();

    protected AbstractCamouflageBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof CamouflageableBlockEntity) {
            BlockState camoState;
            CamouflageableBlockEntity camo = (CamouflageableBlockEntity)te;
            if (!player.isCreative() && (camoState = camo.getCamouflage()) != null) {
                ItemStack camoStack = CamouflageableBlockEntity.getStackForState(camoState);
                camo.setCamouflage(null);
                world.levelEvent(player, 2001, pos, AbstractCamouflageBlock.getId((BlockState)camoState));
                ItemEntity entity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, camoStack);
                world.addFreshEntity((Entity)entity);
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        CamouflageableBlockEntity camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedShape(state, reader, pos, ctx) : camo.getCamouflage().getShape(reader, pos, ctx);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        CamouflageableBlockEntity camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedCollisionShape(state, reader, pos, ctx) : camo.getCamouflage().getCollisionShape(reader, pos, ctx);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRaytraceShape(state, worldIn, pos) : camo.getCamouflage().getVisualShape(worldIn, pos, CollisionContext.empty());
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRenderShape(state, worldIn, pos) : camo.getCamouflage().getBlockSupportShape(worldIn, pos);
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(world, pos);
        return camo == null ? super.getLightBlock(state, world, pos) : camo.getCamouflage().getLightBlock(world, pos);
    }

    public boolean hasDynamicShape() {
        return true;
    }

    private CamouflageableBlockEntity getCamoState(BlockGetter blockAccess, BlockPos pos) {
        CamouflageableBlockEntity camo;
        if (blockAccess == null || pos == null) {
            return null;
        }
        BlockEntity be = blockAccess.getBlockEntity(pos);
        return be instanceof CamouflageableBlockEntity && (camo = (CamouflageableBlockEntity)be).getCamouflage() != null ? (CamouflageableBlockEntity)be : null;
    }

    public abstract VoxelShape getUncamouflagedShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    protected VoxelShape getUncamouflagedCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.getUncamouflagedShape(state, reader, pos, ctx);
    }

    protected VoxelShape getUncamouflagedRenderShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getUncamouflagedShape(state, reader, pos, CollisionContext.empty());
    }

    protected VoxelShape getUncamouflagedRaytraceShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }
}

