/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.inventory.CreativeCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CreativeCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements MenuProvider {
    @GuiSynced
    private float pressureSetpoint;

    public CreativeCompressorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CREATIVE_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 50000, 0);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.pressureSetpoint = tag.getFloat("setpoint");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putFloat("setpoint", this.pressureSetpoint);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.airHandler.setPressure(this.pressureSetpoint);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        try {
            this.pressureSetpoint += Float.parseFloat(tag);
            if (this.pressureSetpoint > 30.0f) {
                this.pressureSetpoint = 30.0f;
            }
            if (this.pressureSetpoint < -1.0f) {
                this.pressureSetpoint = -1.0f;
            }
            this.setChanged();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new CreativeCompressorMenu(i, playerInventory, this.getBlockPos());
    }
}

