/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetEntityAttack;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.common.util.FakePlayer;

public class DroneAIAttackEntity
extends MeleeAttackGoal {
    private final DroneEntity attacker;
    private final AttackType attackType;
    private final ProgWidgetEntityAttack widget;
    private final double rangedAttackRange;

    public DroneAIAttackEntity(DroneEntity attacker, double speed, boolean useLongMemory, String filterString, ProgWidgetEntityAttack widget) {
        super((PathfinderMob)attacker, speed, useLongMemory);
        this.attacker = attacker;
        this.attackType = AttackType.forDrone(attacker);
        this.widget = widget;
        float rangeMult = 1.0f;
        switch (this.attackType.ordinal()) {
            case 1: {
                ItemStack stack = attacker.getMinigun().getAmmoStack();
                Item item = stack.getItem();
                if (!(item instanceof AbstractGunAmmoItem)) break;
                AbstractGunAmmoItem ammo = (AbstractGunAmmoItem)item;
                rangeMult = ammo.getRangeMultiplier(stack);
                break;
            }
            case 2: {
                MicromissilesItem.setEntityFilter(attacker.getInv().getStackInSlot(0), filterString);
                rangeMult = 2.0f;
            }
        }
        this.rangedAttackRange = (float)(16 + Math.min(16, attacker.getUpgrades(ModUpgrades.RANGE.get()))) * rangeMult;
    }

    public boolean canUse() {
        switch (this.attackType.ordinal()) {
            case 1: {
                if (this.attacker.getSlotForAmmo() >= 0) break;
                this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noAmmo");
                return false;
            }
            case 2: {
                if (this.isMissileUsable(this.attacker)) break;
                this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noMissile");
                return false;
            }
        }
        LivingEntity target = this.attacker.getTarget();
        if (target == null || !target.isAlive()) {
            this.attacker.getDebugger().addEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noEntityToAttack");
            return false;
        }
        return super.canUse();
    }

    public void start() {
        super.start();
        this.attacker.incAttackCount();
        if (this.attackType == AttackType.MELEE && this.attacker.getTarget() != null && this.attacker.getInv().getSlots() > 1) {
            this.equipBestMeleeWeapon();
        }
    }

    public boolean canContinueToUse() {
        if (this.attackType != AttackType.MELEE) {
            if (this.widget.useMaxActions() && this.attacker.getAttackCount() >= this.widget.getMaxActions()) {
                return false;
            }
            LivingEntity target = this.attacker.getTarget();
            if (target == null || !target.isAlive() || this.attackType == AttackType.MINIGUN && this.attacker.getSlotForAmmo() < 0 || this.attackType == AttackType.MISSILE && !this.isMissileUsable(this.attacker)) {
                return false;
            }
            double dist = this.attacker.distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
            if (dist < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.getSensing().hasLineOfSight((Entity)target)) {
                return true;
            }
        }
        return super.canContinueToUse();
    }

    public void tick() {
        if (this.attackType != AttackType.MELEE) {
            double dist;
            LivingEntity target = this.attacker.getTarget();
            if (target != null && (dist = this.attacker.distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ())) < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.getSensing().hasLineOfSight((Entity)target)) {
                this.attacker.getFakePlayer().setPos(this.attacker.getX(), this.attacker.getY(), this.attacker.getZ());
                if (this.attackType.doAttack(this.attacker, target)) {
                    this.attacker.incAttackCount();
                }
                if (dist < Math.pow(this.rangedAttackRange * 0.75, 2.0)) {
                    this.attacker.getNavigation().stop();
                }
            }
        } else {
            super.tick();
        }
    }

    private boolean isMissileUsable(DroneEntity drone) {
        ItemStack stack = drone.getInv().getStackInSlot(0);
        return stack.getItem() instanceof MicromissilesItem && stack.getDamageValue() < stack.getMaxDamage();
    }

    private void equipBestMeleeWeapon() {
        int bestSlot = 0;
        double bestDmg = 0.0;
        for (int i = 0; i < this.attacker.getInv().getSlots(); ++i) {
            ItemStack stack = this.attacker.getInv().getStackInSlot(i);
            if (stack.isEmpty()) continue;
            AttributeInstance damage = new AttributeInstance(Attributes.ATTACK_DAMAGE, c -> {});
            stack.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attr, mod) -> {
                if (attr.is(Attributes.ATTACK_DAMAGE)) {
                    damage.addTransientModifier(mod);
                }
            });
            float modified = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.attacker.level()), (ItemStack)stack, (Entity)this.attacker.getTarget(), (DamageSource)this.attacker.damageSources().mobAttack((LivingEntity)this.attacker), (float)((float)damage.getValue()));
            if (!((double)modified > bestDmg)) continue;
            bestDmg = modified;
            bestSlot = i;
        }
        if (bestSlot != 0) {
            ItemStack copy = this.attacker.getInv().getStackInSlot(0).copy();
            this.attacker.getInv().setStackInSlot(0, this.attacker.getInv().getStackInSlot(bestSlot));
            this.attacker.getInv().setStackInSlot(bestSlot, copy);
        }
    }

    private static enum AttackType {
        MELEE,
        MINIGUN,
        MISSILE;


        static AttackType forDrone(DroneEntity drone) {
            if (drone.hasMinigun()) {
                return MINIGUN;
            }
            if (drone.getInv().getStackInSlot(0).getItem() instanceof MicromissilesItem) {
                return MISSILE;
            }
            return MELEE;
        }

        public boolean doAttack(DroneEntity attacker, LivingEntity target) {
            return switch (this.ordinal()) {
                case 1 -> {
                    if (attacker.tryFireMinigun(target).ammoUsed() > 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> AttackType.tryFireMicromissile(attacker, target);
                default -> true;
            };
        }

        private static boolean tryFireMicromissile(DroneEntity attacker, LivingEntity target) {
            FakePlayer fakePlayer = attacker.getFakePlayer();
            fakePlayer.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            ItemStack stack = attacker.getInv().getStackInSlot(0);
            if (stack.getItem() instanceof MicromissilesItem) {
                fakePlayer.gameMode.useItem((ServerPlayer)fakePlayer, attacker.level(), stack, InteractionHand.MAIN_HAND);
                return true;
            }
            return false;
        }
    }
}

