/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.math.NumberUtils;

public class ProgWidgetWait
extends ProgWidget {
    public static final MapCodec<ProgWidgetWait> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetWait.baseParts(builder).apply((Applicative)builder, ProgWidgetWait::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetWait> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetWait::new);

    public ProgWidgetWait(ProgWidget.PositionFields pos) {
        super(pos);
    }

    public ProgWidgetWait() {
        super(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetWait(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.WAIT.get();
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_WAIT;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        return widget instanceof ProgWidgetWait ? (widget.getConnectedParameters()[0] != null ? new DroneAIWait((ProgWidgetText)widget.getConnectedParameters()[0]) : null) : null;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.WHITE;
    }

    private static class DroneAIWait
    extends Goal {
        private final int maxTicks;
        private int ticks;

        private DroneAIWait(ProgWidgetText widget) {
            String time = widget.string;
            int multiplier = 1;
            if (time.endsWith("s") || time.endsWith("S")) {
                multiplier = 20;
                time = time.substring(0, time.length() - 1);
            } else if (time.endsWith("m") || time.endsWith("M")) {
                multiplier = 1200;
                time = time.substring(0, time.length() - 1);
            }
            this.maxTicks = NumberUtils.toInt((String)time) * multiplier;
        }

        public boolean canUse() {
            return this.ticks < this.maxTicks;
        }

        public boolean canContinueToUse() {
            ++this.ticks;
            return this.canUse();
        }
    }
}

