/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractTameableHack<T extends LivingEntity>
implements IHackableEntity<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHack(Entity entity, Player player) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal t = (TamableAnimal)entity;
            if (!player.getUUID().equals(t.getOwnerUUID())) return true;
        }
        if (!(entity instanceof Horse)) return false;
        Horse h = (Horse)entity;
        if (player.getUUID().equals(h.getOwnerUUID())) return false;
        return true;
    }

    @Override
    public void addHackInfo(T entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.tame", new Object[0]));
    }

    @Override
    public void addPostHackInfo(T entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.tamed", new Object[0]));
    }

    @Override
    public int getHackTime(T entity, Player player) {
        return 60;
    }
}

