/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.network.DescSynced;

public class SyncedTemperature {
    private static final int SYNC_RATE = 60;
    private final IHeatExchangerLogic logic;
    private int syncTimer = -1;
    private int pendingTemp;
    @DescSynced
    private int syncedTemp = -1;

    public SyncedTemperature(IHeatExchangerLogic logic) {
        this.logic = logic;
    }

    public int getSyncedTemp() {
        return this.syncedTemp == -1 ? this.logic.getTemperatureAsInt() : this.syncedTemp;
    }

    public void tick() {
        int currentTemp = this.logic.getTemperatureAsInt();
        if (this.shouldSyncNow()) {
            this.syncedTemp = currentTemp;
            this.syncTimer = -1;
        } else if (currentTemp != this.syncedTemp) {
            if (this.syncTimer == -1) {
                this.syncTimer = 60;
            }
            this.pendingTemp = currentTemp;
        }
        if (this.syncTimer >= 0 && --this.syncTimer == -1) {
            this.syncedTemp = this.pendingTemp;
        }
    }

    private boolean shouldSyncNow() {
        int currentTemp = this.logic.getTemperatureAsInt();
        if (this.syncedTemp < 0) {
            return true;
        }
        int delta = Math.abs(this.syncedTemp - currentTemp);
        if (currentTemp < 73) {
            return false;
        }
        if (currentTemp < 473) {
            return delta >= 10;
        }
        if (currentTemp < 873) {
            return delta >= 30;
        }
        if (currentTemp < 1473) {
            return delta >= 80;
        }
        return false;
    }
}

