/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorExtensionData;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradableItemUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class CommonArmorHandler
implements ICommonArmorHandler {
    private static final CommonArmorHandler clientHandler = new CommonArmorHandler(null);
    private static final CommonArmorHandler serverHandler = new CommonArmorHandler(null);
    private static final Vec3 FORWARD = new Vec3(0.0, 0.0, 1.0);
    public static final float CRITICAL_PRESSURE = 0.1f;
    public static final float LOW_PRESSURE = 0.5f;
    private final Map<UUID, CommonArmorHandler> playerHandlers = new HashMap<UUID, CommonArmorHandler>();
    private Player player;
    private final boolean[][] upgradeRenderersInserted = new boolean[4][];
    private final boolean[][] upgradeRenderersEnabled = new boolean[4][];
    private final int[] ticksSinceEquip = new int[4];
    private final List<IAirHandlerItem> airHandlers = new ArrayList<IAirHandlerItem>();
    private final List<Map<PNCUpgrade, Integer>> upgradeMatrix = new ArrayList<Map<PNCUpgrade, Integer>>();
    private final int[] startupTimes = new int[4];
    private final IArmorExtensionData[][] extensionData = new IArmorExtensionData[4][];
    private boolean isValid;

    private CommonArmorHandler(Player player) {
        this.player = player;
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            this.upgradeRenderersInserted[slot.getIndex()] = new boolean[upgradeHandlers.size()];
            this.upgradeRenderersEnabled[slot.getIndex()] = new boolean[upgradeHandlers.size()];
            this.upgradeMatrix.add(new HashMap());
            this.airHandlers.add(null);
            this.extensionData[slot.getIndex()] = new IArmorExtensionData[upgradeHandlers.size()];
            for (IArmorUpgradeHandler<?> handler : upgradeHandlers) {
                this.extensionData[slot.getIndex()][handler.getIndex()] = (IArmorExtensionData)handler.extensionData().get();
            }
        }
        Arrays.fill(this.startupTimes, 200);
        this.isValid = true;
    }

    private static CommonArmorHandler getManagerInstance(Player player) {
        return player.level().isClientSide ? clientHandler : serverHandler;
    }

    public static CommonArmorHandler getHandlerForPlayer(Player player) {
        return CommonArmorHandler.getManagerInstance((Player)player).playerHandlers.computeIfAbsent(player.getUUID(), v -> new CommonArmorHandler(player));
    }

    public static CommonArmorHandler getHandlerForPlayer() {
        return CommonArmorHandler.getHandlerForPlayer(ClientUtils.getClientPlayer());
    }

    public void armorSwitched(EquipmentSlot slot) {
        if (this.ticksSinceEquip[slot.getIndex()] > 0) {
            this.airHandlers.set(slot.getIndex(), null);
            if (this.ticksSinceEquip[slot.getIndex()] > 1) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.getIndex()] = 0;
        }
    }

    @Override
    public <T extends IArmorExtensionData> T getExtensionData(IArmorUpgradeHandler<T> handler) {
        return (T)this.extensionData[handler.getEquipmentSlot().getIndex()][handler.getIndex()];
    }

    private static void clearHandlerForPlayer(Player player) {
        CommonArmorHandler h = CommonArmorHandler.getManagerInstance(player);
        h.playerHandlers.computeIfPresent(player.getUUID(), (name, val) -> {
            val.invalidate();
            return null;
        });
    }

    public void tickArmorPiece(EquipmentSlot slot) {
        ItemStack armorStack = this.player.getItemBySlot(slot);
        boolean armorActive = false;
        if (armorStack.getItem() instanceof PneumaticArmorItem) {
            this.airHandlers.set(slot.getIndex(), (IAirHandlerItem)armorStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM));
            if (this.ticksSinceEquip[slot.getIndex()] == 0) {
                this.initArmorInventory(slot);
            }
            int n = slot.getIndex();
            this.ticksSinceEquip[n] = this.ticksSinceEquip[n] + 1;
            if (this.isArmorEnabled() && this.getArmorPressure(slot) > 0.0f) {
                float airUsage;
                armorActive = true;
                if (!this.player.level().isClientSide && this.isArmorReady(slot) && !this.player.isCreative() && (airUsage = this.getIdleAirUsage(slot, false)) != 0.0f) {
                    this.addAir(slot, (int)(-airUsage));
                }
                this.doArmorActions(slot);
            }
        } else {
            this.airHandlers.set(slot.getIndex(), null);
        }
        if (!armorActive) {
            if (this.ticksSinceEquip[slot.getIndex()] > 1) {
                this.onArmorRemoved(slot);
            }
            this.ticksSinceEquip[slot.getIndex()] = 0;
        }
    }

    public float getIdleAirUsage(EquipmentSlot slot, boolean countDisabled) {
        float totalUsage = 0.0f;
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i) || !countDisabled && !this.isUpgradeEnabled(slot, i)) continue;
            totalUsage += handlers.get(i).getIdleAirUsage(this);
        }
        return totalUsage;
    }

    private void onArmorRemoved(EquipmentSlot slot) {
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).onShutdown(this);
        }
    }

    @Override
    public float addAir(EquipmentSlot slot, int airAmount) {
        IAirHandlerItem handler;
        float oldPressure = this.getArmorPressure(slot);
        if (!(this.player.isCreative() && airAmount <= 0 || this.getUpgradeCount(slot, ModUpgrades.CREATIVE.get()) != 0 || (handler = this.airHandlers.get(slot.getIndex())) == null)) {
            handler.addAir(airAmount);
        }
        return oldPressure;
    }

    private void doArmorActions(EquipmentSlot slot) {
        if (!this.isArmorReady(slot)) {
            return;
        }
        List<IArmorUpgradeHandler<?>> handlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        for (int i = 0; i < handlers.size(); ++i) {
            if (!this.isUpgradeInserted(slot, i)) continue;
            handlers.get(i).tick(this, this.isUpgradeEnabled(slot, i));
        }
        if (slot == EquipmentSlot.FEET && this.player.level().isClientSide && this.player.isInWater() && this.player.zza > 0.0f && this.isArmorReady(EquipmentSlot.FEET) && this.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.FLIPPERS.get()) > 0) {
            this.player.moveRelative(this.player.onGround() ? ((Double)ConfigHelper.common().armor.flippersSpeedBoostGround.get()).floatValue() : ((Double)ConfigHelper.common().armor.flippersSpeedBoostFloating.get()).floatValue(), FORWARD);
        }
        if (!this.player.level().isClientSide && this.getUpgradeCount(slot, ModUpgrades.ITEM_LIFE.get()) > 0) {
            this.tryRepairArmor(slot);
        }
    }

    private void tryRepairArmor(EquipmentSlot slot) {
        int upgrades = this.getUpgradeCount(slot, ModUpgrades.ITEM_LIFE.get(), 5);
        int interval = 120 - 20 * upgrades;
        int airUsage = (Integer)ConfigHelper.common().armor.repairAirUsage.get() * upgrades;
        ItemStack armorStack = this.player.getItemBySlot(slot);
        if (armorStack.getDamageValue() > 0 && this.hasMinPressure(slot) && this.ticksSinceEquip[slot.getIndex()] % interval == 0) {
            this.addAir(slot, -airUsage);
            armorStack.setDamageValue(armorStack.getDamageValue() - 1);
        }
    }

    public void initArmorInventory(EquipmentSlot slot) {
        ItemStack armorStack = this.player.getItemBySlot(slot);
        HashMap<PNCUpgrade, Integer> upgrades = new HashMap<PNCUpgrade, Integer>(UpgradableItemUtils.getUpgrades(armorStack));
        upgrades.keySet().removeIf(u -> UpgradableItemUtils.isUpgradeBlacklisted(armorStack.getItem(), u.getItemStack()));
        Arrays.fill(this.upgradeRenderersInserted[slot.getIndex()], false);
        for (int i = 0; i < this.upgradeRenderersInserted[slot.getIndex()].length; ++i) {
            this.upgradeRenderersInserted[slot.getIndex()][i] = this.isModuleEnabled(upgrades.keySet(), ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(i));
        }
        this.upgradeMatrix.get(slot.getIndex()).clear();
        upgrades.forEach((upgrade, count) -> this.upgradeMatrix.get(slot.getIndex()).put((PNCUpgrade)upgrade, (Integer)count));
        this.startupTimes[slot.getIndex()] = (int)((double)((Integer)ConfigHelper.common().armor.armorStartupTime.get()).intValue() * Math.pow(0.8, this.getSpeedFromUpgrades(slot) - 1));
        ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(handler -> {
            if (this.isUpgradeInserted(slot, handler.getIndex())) {
                handler.onInit(this);
            }
        });
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getUpgradeCount(EquipmentSlot slot, PNCUpgrade upgrade) {
        return this.upgradeMatrix.get(slot.getIndex()).getOrDefault(upgrade, 0);
    }

    public int getUpgradeCount(EquipmentSlot slot, PNCUpgrade upgrade, int max) {
        return Math.min(max, this.getUpgradeCount(slot, upgrade));
    }

    public boolean isUpgradeInserted(EquipmentSlot slot, int featureIndex) {
        return this.upgradeRenderersInserted[slot.getIndex()][featureIndex];
    }

    public boolean isUpgradeEnabled(EquipmentSlot slot, int featureIndex) {
        return this.upgradeRenderersEnabled[slot.getIndex()][featureIndex];
    }

    public void setUpgradeEnabled(EquipmentSlot slot, byte featureIndex, boolean state) {
        this.upgradeRenderersEnabled[slot.getIndex()][featureIndex] = state;
        IArmorUpgradeHandler<?> handler = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).get(featureIndex);
        handler.onToggle(this, state);
    }

    public int getTicksSinceEquipped(EquipmentSlot slot) {
        return this.ticksSinceEquip[slot.getIndex()];
    }

    private boolean isModuleEnabled(Set<PNCUpgrade> upgrades, IArmorUpgradeHandler<?> handler) {
        return Arrays.stream(handler.getRequiredUpgrades()).allMatch(upgrades::contains);
    }

    @Override
    public int getSpeedFromUpgrades(EquipmentSlot slot) {
        return 1 + this.getUpgradeCount(slot, ModUpgrades.SPEED.get());
    }

    public int getStartupTime(EquipmentSlot slot) {
        return this.startupTimes[slot.getIndex()];
    }

    public boolean isArmorReady(EquipmentSlot slot) {
        return this.getTicksSinceEquipped(slot) > this.getStartupTime(slot);
    }

    @Override
    public float getArmorPressure(EquipmentSlot slot) {
        IAirHandlerItem handler = this.airHandlers.get(slot.getIndex());
        return handler == null ? 0.0f : handler.getPressure();
    }

    @Override
    public int getAir(EquipmentSlot slot) {
        IAirHandlerItem handler = this.airHandlers.get(slot.getIndex());
        return handler == null ? 0 : handler.getAir();
    }

    @Override
    public boolean isArmorEnabled() {
        return this.isUpgradeEnabled(EquipmentSlot.HEAD, CommonUpgradeHandlers.coreComponentsHandler.getIndex());
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void addArmorMessage(Component message, int duration, int bgColor) {
        if (this.player.level().isClientSide) {
            HUDHandler.getInstance().addMessage(message, List.of(), duration, bgColor);
        } else {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new PacketSendArmorHUDMessage(message, duration, bgColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public boolean hasMinPressure(EquipmentSlot slot) {
        return this.getArmorPressure(slot) >= 0.1f;
    }

    @Override
    public boolean upgradeUsable(IArmorUpgradeHandler<?> upgrade, boolean mustBeActive) {
        EquipmentSlot slot = upgrade.getEquipmentSlot();
        int idx = upgrade.getIndex();
        return this.isArmorEnabled() && this.isArmorReady(slot) && this.hasMinPressure(slot) && this.isUpgradeInserted(slot, idx) && (!mustBeActive || this.isUpgradeEnabled(slot, idx));
    }

    @Override
    public boolean isUpgradeEnabled(IArmorUpgradeHandler<?> upgrade) {
        return this.isUpgradeEnabled(upgrade.getEquipmentSlot(), upgrade.getIndex());
    }

    @Override
    public void setUpgradeEnabled(IArmorUpgradeHandler<?> upgrade, boolean enabled) {
        if (this.isUpgradeEnabled(upgrade) != enabled && this.upgradeUsable(upgrade, false)) {
            if (this.player.level().isClientSide) {
                ClientUtils.setArmorUpgradeEnabled(upgrade.getEquipmentSlot(), (byte)upgrade.getIndex(), enabled);
            } else {
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkHandler.sendToPlayer(new PacketToggleArmorFeature(new PacketToggleArmorFeature.FeatureSetting(upgrade.getEquipmentSlot(), (byte)upgrade.getIndex(), enabled)), sp);
                }
            }
        }
    }

    @Override
    public boolean isOnCooldown(EquipmentSlot slot) {
        return this.player.getCooldowns().isOnCooldown(this.player.getItemBySlot(slot).getItem());
    }

    @EventBusSubscriber(modid="pneumaticcraft", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ClientListeners {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientUtils.getOptionalClientPlayer().ifPresent(CommonArmorHandler::clearHandlerForPlayer);
        }

        @SubscribeEvent
        public static void tickEnd(ClientTickEvent.Post event) {
            if (ClientUtils.getOptionalClientPlayer().isEmpty() && ArmorUpgradeRegistry.getInstance().isFrozen() && ClientArmorRegistry.getInstance().isFrozen()) {
                for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    ClientArmorRegistry.getInstance().getHandlersForSlot(slot).forEach(IArmorUpgradeClientHandler::reset);
                }
            }
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft", bus=EventBusSubscriber.Bus.GAME)
    public static class Listeners {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.getEntity());
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                handler.tickArmorPiece(slot);
            }
        }

        @SubscribeEvent
        public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            CommonArmorHandler.clearHandlerForPlayer(event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
            Player player;
            CommonArmorHandler handler;
            Entity entity = event.getEntity();
            if (entity instanceof Player && (handler = CommonArmorHandler.getManagerInstance((Player)player).playerHandlers.get((player = (Player)entity).getUUID())) != null) {
                handler.player = player;
            }
        }
    }
}

