/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.block.entity.processing.FluidMixerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.ThermoPlantBlockEntity;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.recipes.RecipeCaches;
import me.desht.pneumaticcraft.common.recipes.VanillaRecipeCache;
import me.desht.pneumaticcraft.common.recipes.machine.AssemblyRecipeImpl;
import me.desht.pneumaticcraft.common.recipes.machine.HeatFrameCoolingRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PneumaticCraftRecipeType<T extends PneumaticCraftRecipe>
implements RecipeType<T> {
    private static CacheReloadListener cacheReloadListener;
    private final Map<ResourceLocation, RecipeHolder<T>> cachedRecipes = new HashMap<ResourceLocation, RecipeHolder<T>>();
    private final String typeName;

    public PneumaticCraftRecipeType(String name) {
        this.typeName = "PneumaticCraftRecipeType[" + String.valueOf(PneumaticRegistry.RL(name)) + "]";
    }

    public String toString() {
        return this.typeName;
    }

    public Map<ResourceLocation, RecipeHolder<T>> getRecipeMap(Level level) {
        if (level == null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                level = server.getLevel(Level.OVERWORLD);
            }
            if (level == null) {
                Log.error("detected someone trying to get recipes for {} with no world available - returning empty recipe list", this);
                return Collections.emptyMap();
            }
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = level.getRecipeManager();
            List recipes = recipeManager.getRecipesFor((RecipeType)this, (RecipeInput)CraftingInput.EMPTY, level);
            recipes.forEach(recipe -> this.cachedRecipes.put(recipe.id(), (RecipeHolder<T>)recipe));
            if (this == ModRecipeTypes.ASSEMBLY_DRILL_LASER.get()) {
                List drillRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.ASSEMBLY_DRILL.get());
                List laserRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.ASSEMBLY_LASER.get());
                AssemblyRecipeImpl.calculateAssemblyChain(drillRecipes, laserRecipes).forEach((id, recipe) -> this.cachedRecipes.put((ResourceLocation)id, (RecipeHolder<T>)recipe));
            } else if (this == ModRecipeTypes.FLUID_MIXER.get()) {
                List<FluidMixerRecipe> l = recipes.stream().filter(r -> r.value() instanceof FluidMixerRecipe).map(r -> (FluidMixerRecipe)r.value()).toList();
                FluidMixerBlockEntity.cacheRecipeFluids(l);
            }
        }
        return this.cachedRecipes;
    }

    public Collection<RecipeHolder<T>> allRecipeHolders(Level level) {
        return Collections.unmodifiableCollection(this.getRecipeMap(level).values());
    }

    public Collection<T> allRecipes(Level level) {
        return this.getRecipeMap(level).values().stream().map(RecipeHolder::value).toList();
    }

    public Stream<RecipeHolder<T>> stream(Level level) {
        return this.getRecipeMap(level).values().stream();
    }

    public Optional<RecipeHolder<T>> findFirst(Level level, Predicate<T> predicate) {
        return this.stream(level).filter(holder -> predicate.test((PneumaticCraftRecipe)holder.value())).findFirst();
    }

    public Optional<RecipeHolder<T>> getRecipe(Level level, ResourceLocation recipeId) {
        return Optional.ofNullable(this.getRecipeMap(level).get(recipeId));
    }

    public static CacheReloadListener getCacheReloadListener() {
        if (cacheReloadListener == null) {
            cacheReloadListener = new CacheReloadListener();
        }
        return cacheReloadListener;
    }

    public static void clearCachedRecipes() {
        for (DeferredHolder type : ModRecipeTypes.RECIPE_TYPES.getEntries()) {
            Object object = type.get();
            if (!(object instanceof PneumaticCraftRecipeType)) continue;
            PneumaticCraftRecipeType pncrType = (PneumaticCraftRecipeType)object;
            pncrType.cachedRecipes.clear();
        }
        HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(Collections.emptyList());
        FluidMixerBlockEntity.clearCachedFluids();
        PressureChamberInterfaceBlockEntity.clearCachedItems();
        ThermoPlantBlockEntity.clearCachedItemsAndFluids();
        RefineryControllerBlockEntity.clearCachedFluids();
        AmadronOfferManager.getInstance().rebuildRequired();
        FuelRegistry.getInstance().clearCachedFuelFluids();
        BlockHeatProperties.getInstance().clear();
        VanillaRecipeCache.clearAll();
        RecipeCaches.clearAll();
    }

    public static class CacheReloadListener
    implements PreparableReloadListener {
        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(() -> {
                PneumaticCraftRecipeType.clearCachedRecipes();
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    NetworkHandler.sendToAll(PacketClearRecipeCache.INSTANCE);
                }
            }, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0));
        }
    }
}

