/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class JEISpawnerExtractionCategory
extends AbstractPNCCategory<SpawnerExtractionRecipe> {
    private static final List<EntityType<?>> ENTITY_TYPES = new ArrayList();

    public JEISpawnerExtractionCategory() {
        super(RecipeTypes.SPAWNER_EXTRACTION, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.spawnerExtraction", new Object[0]), (IDrawable)JEISpawnerExtractionCategory.guiHelper().createDrawable(Textures.GUI_JEI_SPAWNER_EXTRACTION, 0, 0, 120, 64), JEISpawnerExtractionCategory.guiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SPAWNER_EXTRACTOR.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawnerExtractionRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 53, 3).addItemStack(recipe.itemInput);
        builder.addSlot(RecipeIngredientRole.INPUT, 53, 34).addItemStack(new ItemStack((ItemLike)Blocks.SPAWNER));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 18, 34).addItemStacks(recipe.cores);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 34).addItemStack(recipe.itemOutput);
    }

    public static List<SpawnerExtractionRecipe> getAllRecipes() {
        ArrayList<ItemStack> cores = new ArrayList<ItemStack>();
        for (EntityType<?> type : ENTITY_TYPES) {
            ItemStack core = new ItemStack((ItemLike)ModItems.SPAWNER_CORE.get());
            ISpawnerCoreStats stats = PneumaticRegistry.getInstance().getItemRegistry().getSpawnerCoreStats(core);
            stats.addAmount(type, 100).save(core);
            cores.add(core);
        }
        return List.of(new SpawnerExtractionRecipe(new ItemStack((ItemLike)ModBlocks.SPAWNER_EXTRACTOR.get()), cores, new ItemStack((ItemLike)ModBlocks.EMPTY_SPAWNER.get())));
    }

    static {
        ENTITY_TYPES.add(EntityType.ZOMBIE);
        ENTITY_TYPES.add(EntityType.SKELETON);
        ENTITY_TYPES.add(EntityType.CREEPER);
    }

    public record SpawnerExtractionRecipe(ItemStack itemInput, List<ItemStack> cores, ItemStack itemOutput) {
    }
}

