/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.PatchouliAccess;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorThermoPlant
implements IComponentProcessor {
    private ThermoPlantRecipe recipe = null;
    private String header = null;

    public void setup(Level level, IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = ResourceLocation.parse((String)iVariableProvider.get("recipe", (HolderLookup.Provider)level.registryAccess()).asString());
        ModRecipeTypes.THERMO_PLANT.get().getRecipe((Level)Minecraft.getInstance().level, recipeId).ifPresentOrElse(h -> {
            this.recipe = (ThermoPlantRecipe)h.value();
        }, () -> Log.warning("Missing thermoplant recipe: " + String.valueOf(recipeId), new Object[0]));
        this.header = iVariableProvider.has("header") ? iVariableProvider.get("header", (HolderLookup.Provider)level.registryAccess()).asString() : "";
    }

    public IVariable process(Level level, String s) {
        if (this.recipe == null) {
            return null;
        }
        switch (s) {
            case "header": {
                return IVariable.wrap((String)(this.header.isEmpty() ? this.defaultHeader() : this.header));
            }
            case "item_input": {
                return PatchouliAccess.getStacks(this.recipe.getInputItem().orElse(Ingredient.EMPTY), (HolderLookup.Provider)level.registryAccess());
            }
            case "fluid_input": {
                return this.recipe.getInputFluid().map(ingr -> PatchouliAccess.getFluidStacks(ingr, (HolderLookup.Provider)level.registryAccess())).orElse(IVariable.empty());
            }
            case "item_output": {
                return IVariable.from((Object)this.recipe.getOutputItem(), (HolderLookup.Provider)level.registryAccess());
            }
            case "fluid_output": {
                return IVariable.from((Object)this.recipe.getOutputFluid(), (HolderLookup.Provider)level.registryAccess());
            }
            case "text": {
                String pr = PneumaticCraftUtils.roundNumberTo(this.recipe.getRequiredPressure(), 1);
                String temp = this.recipe.getOperatingTemperature().asString(TemperatureRange.TemperatureScale.CELSIUS);
                return IVariable.wrap((String)I18n.get((String)"pneumaticcraft.patchouli.processor.thermoPlant.desc", (Object[])new Object[]{pr, temp}));
            }
            case "scale": {
                return IVariable.wrap((Number)this.getScale(this.recipe));
            }
        }
        return null;
    }

    private int getScale(ThermoPlantRecipe recipe) {
        int in = recipe.getInputFluidAmount();
        int out = recipe.getOutputFluid().getAmount();
        if (in >= 4000 || out >= 4000) {
            return 16000;
        }
        return 2 * Math.max(in, out);
    }

    private String defaultHeader() {
        if (!this.recipe.getOutputFluid().isEmpty()) {
            return this.recipe.getOutputFluid().getHoverName().getString();
        }
        if (!this.recipe.getOutputItem().isEmpty()) {
            return this.recipe.getOutputItem().getHoverName().getString();
        }
        return "";
    }
}

