/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.entityfilter;

import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.entityfilter.EntityFilter;
import me.desht.pneumaticcraft.common.util.entityfilter.FilterModifier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.common.IShearable;

public enum FilterModifiers {
    INSTANCE;

    private final Map<String, FilterModifier> modifierMap = new ConcurrentHashMap<String, FilterModifier>();

    public void registerModifier(String name, Set<String> options, BiPredicate<Entity, String> predicate) {
        this.modifierMap.put(name.toLowerCase(Locale.ROOT), new FilterModifier(options, predicate));
    }

    public void registerModifier(String name, Predicate<String> validator, String desc, BiPredicate<Entity, String> predicate) {
        this.modifierMap.put(name.toLowerCase(Locale.ROOT), new FilterModifier(validator, desc, predicate));
    }

    public Optional<FilterModifier> getModifier(String name) {
        return Optional.ofNullable(this.modifierMap.get(name.toLowerCase(Locale.ROOT)));
    }

    public void registerDefaults() {
        this.registerModifier("age", Set.of("adult", "baby"), FilterModifiers::testAge);
        this.registerModifier("aquatic", Set.of("yes", "no"), (entity, val) -> FilterModifiers.testEntityTypeTag(entity, val, EntityTypeTags.AQUATIC));
        this.registerModifier("undead", Set.of("yes", "no"), (entity, val) -> FilterModifiers.testEntityTypeTag(entity, val, EntityTypeTags.UNDEAD));
        this.registerModifier("illager", Set.of("yes", "no"), (entity, val) -> FilterModifiers.testEntityTypeTag(entity, val, EntityTypeTags.ILLAGER));
        this.registerModifier("arthropod", Set.of("yes", "no"), (entity, val) -> FilterModifiers.testEntityTypeTag(entity, val, EntityTypeTags.ARTHROPOD));
        this.registerModifier("breedable", Set.of("yes", "no"), FilterModifiers::testBreedable);
        this.registerModifier("shearable", Set.of("yes", "no"), FilterModifiers::testShearable);
        this.registerModifier("color", EntityFilter.DYE_COLORS, FilterModifiers::hasColor);
        this.registerModifier("holding", item -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)item)), "any valid item ID, e.g. 'minecraft:cobblestone'", (entity, val) -> FilterModifiers.isHeldItem(entity, val, true));
        this.registerModifier("holding_offhand", item -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)item)), "any valid item ID, e.g. 'minecraft:cobblestone'", (entity, val) -> FilterModifiers.isHeldItem(entity, val, false));
        this.registerModifier("mod", str -> true, "any mod name, e.g. 'minecraft' or 'pneumaticcraft'", FilterModifiers::testMod);
        this.registerModifier("entity_tag", str -> true, "any string tag (added to entities with the /tag command)", FilterModifiers::testEntityTag);
        this.registerModifier("type_tag", rl -> ResourceLocation.tryParse((String)rl) != null, "any known entity type tag, e.g 'minecraft:skeletons'", FilterModifiers::testTypeTag);
        this.registerModifier("team", str -> true, "any valid Minecraft team name", FilterModifiers::testTeamName);
    }

    private static boolean testShearable(Entity entity, String val) {
        IShearable s;
        return entity instanceof IShearable && (s = (IShearable)entity).isShearable(null, new ItemStack((ItemLike)Items.SHEARS), entity.getCommandSenderWorld(), entity.blockPosition()) ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
    }

    private static boolean testBreedable(Entity entity, String val) {
        Animal a;
        return entity instanceof Animal && val.equalsIgnoreCase((a = (Animal)entity).getAge() == 0 ? "yes" : "no");
    }

    private static boolean testEntityTypeTag(Entity entity, String val, TagKey<EntityType<?>> key) {
        return val.equalsIgnoreCase(entity.getType().is(key) ? "yes" : "no");
    }

    private static boolean testAge(Entity entity, String val) {
        AgeableMob a;
        return val.equalsIgnoreCase(entity instanceof AgeableMob && (a = (AgeableMob)entity).getAge() >= 0 ? "adult" : "baby");
    }

    private static boolean testMod(Entity entity, String modName) {
        ResourceLocation rl = PneumaticCraftUtils.getRegistryName(entity).orElseThrow();
        return rl.getNamespace().toLowerCase(Locale.ROOT).equals(modName.toLowerCase(Locale.ROOT));
    }

    private static boolean testEntityTag(Entity entity, String val) {
        return entity.getTags().contains(val);
    }

    private static boolean testTypeTag(Entity entity, String val) {
        return ResourceLocation.read((String)val).result().map(rl -> entity.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)rl))).orElse(false);
    }

    private static boolean testTeamName(Entity entity, String val) {
        PlayerTeam team = entity.getTeam();
        return team != null && (team.getName().equalsIgnoreCase(val) || team.getDisplayName().getString().equalsIgnoreCase(val));
    }

    private static boolean hasColor(Entity entity, String val) {
        Entity entity2 = entity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Sheep.class, Wolf.class, Cat.class}, (Object)entity2, n)) {
            case 0 -> {
                Sheep s = (Sheep)entity2;
                yield s.getColor().getName().equalsIgnoreCase(val);
            }
            case 1 -> {
                Wolf w = (Wolf)entity2;
                yield w.getCollarColor().getName().equalsIgnoreCase(val);
            }
            case 2 -> {
                Cat c = (Cat)entity2;
                yield c.getCollarColor().getName().equalsIgnoreCase(val);
            }
            default -> false;
        };
    }

    private static boolean isHeldItem(Entity entity, String name, boolean mainHand) {
        if (entity instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity;
            if (((String)name).startsWith("#")) {
                try {
                    TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)((String)name).substring(1)));
                    return mainHand ? l.getMainHandItem().is(tag) : l.getOffhandItem().is(tag);
                }
                catch (ResourceLocationException ignored) {
                    return false;
                }
            }
            if (!((String)name).contains(":")) {
                name = "minecraft:" + (String)name;
            }
            ItemStack stack = mainHand ? l.getMainHandItem() : l.getOffhandItem();
            return PneumaticCraftUtils.getRegistryName(stack.getItem()).orElseThrow().toString().equals(name);
        }
        return false;
    }
}

