/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.jei;

import cy.jdkdigital.jearchaeology.JEArchaeology;
import cy.jdkdigital.jearchaeology.compat.CompatHandler;
import cy.jdkdigital.jearchaeology.jei.BrushRecipeCategory;
import cy.jdkdigital.jearchaeology.jei.SniffRecipeCategory;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"jearchaeology", (String)"jearchaeology");
    public static Supplier<RecipeType<RecipeHolder<SniffRecipe>>> SNIFF_RECIPE_TYPE = RecipeType.createFromDeferredVanilla(JEArchaeology.SNIFF_TYPE);
    public static Supplier<RecipeType<RecipeHolder<BrushingRecipe>>> BRUSH_RECIPE_TYPE = RecipeType.createFromDeferredVanilla(JEArchaeology.BRUSH_TYPE);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.SNIFFER_EGG), new RecipeType[]{SNIFF_RECIPE_TYPE.get()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.BRUSH), new RecipeType[]{BRUSH_RECIPE_TYPE.get()});
        CompatHandler.addRecipeCatalyst(registration, BRUSH_RECIPE_TYPE.get());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new SniffRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BrushRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(SNIFF_RECIPE_TYPE.get(), recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)JEArchaeology.SNIFF_TYPE.get()));
        registration.addRecipes(BRUSH_RECIPE_TYPE.get(), recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)JEArchaeology.BRUSH_TYPE.get()));
    }
}

