/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.client.FoodItems;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class FoodData {
    public final FoodList foodList;
    public final ProgressInfo progressInfo;
    public final List<Item> validFoods;
    public final List<Item> eatenFoods;
    public final List<Item> uneatenFoods;

    FoodData(FoodList foodList) {
        this.foodList = foodList;
        this.progressInfo = foodList.getProgressInfo();
        this.validFoods = FoodItems.getAllFoods().stream().filter(SOLCarrotConfig::isHearty).collect(Collectors.toList());
        this.eatenFoods = new ArrayList<Item>();
        this.uneatenFoods = new ArrayList<Item>();
        for (Item food : this.validFoods) {
            (foodList.hasEaten(food) ? this.eatenFoods : this.uneatenFoods).add(food);
        }
    }
}

