/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.InventoryCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class InventoryLookCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"read").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes(ctx -> InventoryLookCommand.printInventory((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))));
    }

    public static int printInventory(CommandContext<CommandSourceStack> context, String name) {
        WorldUtils.applyToPlayer(name, ((CommandSourceStack)context.getSource()).getServer(), playerEntity -> {
            int i;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.coloredComponent("Offhand", ChatFormatting.DARK_AQUA), true);
            for (i = 0; i < playerEntity.getInventory().offhand.size(); ++i) {
                if (((ItemStack)playerEntity.getInventory().offhand.get(i)).isEmpty()) continue;
                CommandUtils.sendItemInventoryRemovalMessage((CommandSourceStack)context.getSource(), name, (ItemStack)playerEntity.getInventory().offhand.get(i), "offhand", i);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.coloredComponent("Armor", ChatFormatting.DARK_AQUA), true);
            for (i = 0; i < playerEntity.getInventory().armor.size(); ++i) {
                if (((ItemStack)playerEntity.getInventory().armor.get(i)).isEmpty()) continue;
                CommandUtils.sendItemInventoryRemovalMessage((CommandSourceStack)context.getSource(), name, (ItemStack)playerEntity.getInventory().armor.get(i), "armor", i);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.coloredComponent("Inventory", ChatFormatting.DARK_AQUA), true);
            for (i = 0; i < playerEntity.getInventory().items.size(); ++i) {
                if (((ItemStack)playerEntity.getInventory().items.get(i)).isEmpty()) continue;
                CommandUtils.sendItemInventoryRemovalMessage((CommandSourceStack)context.getSource(), name, (ItemStack)playerEntity.getInventory().items.get(i), "inventory", i);
            }
            if (CrashUtils.curiosLoaded) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.coloredComponent("Curios", ChatFormatting.DARK_AQUA), true);
                Optional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)playerEntity);
                ICuriosItemHandler handler = itemHandler.orElse(null);
                handler.getCurios().forEach((k, v) -> {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.coloredComponent(k, ChatFormatting.DARK_AQUA), true);
                    for (int i = 0; i < v.getSlots(); ++i) {
                        if (v.getStacks().getStackInSlot(i).isEmpty()) continue;
                        CommandUtils.sendItemInventoryRemovalMessage((CommandSourceStack)context.getSource(), name, v.getStacks().getStackInSlot(i), k, i);
                    }
                });
            }
        });
        return 1;
    }
}

