/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nolijium.mixinextras.lib.apache.commons.tuple.Pair;
import nolijium.mixinextras.sugar.SugarBridge;
import nolijium.mixinextras.sugar.impl.SugarApplicationException;
import nolijium.mixinextras.sugar.impl.SugarInjector;
import nolijium.mixinextras.sugar.impl.handlers.HandlerInfo;
import nolijium.mixinextras.utils.CompatibilityHelper;
import nolijium.mixinextras.utils.GenericParamParser;
import nolijium.mixinextras.utils.MixinInternals;
import nolijium.mixinextras.wrapper.InjectorWrapperImpl;
import nolijium.mixinextras.wrapper.InjectorWrapperImpl$HandlerCallCallback;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.asm.MethodNodeEx;

public class SugarWrapperImpl
extends InjectorWrapperImpl {
    private final InjectionInfo wrapperInfo;
    private final AnnotationNode originalAnnotation;
    private final List sugarAnnotations;
    private final ArrayList generics;
    private final MethodNode handler;
    private final InjectionInfo delegate;
    private final SugarInjector sugarInjector;

    protected SugarWrapperImpl(InjectionInfo injectionInfo, MixinTargetContext mixinTargetContext, MethodNode methodNode, AnnotationNode annotationNode) {
        super(injectionInfo, mixinTargetContext, methodNode, annotationNode, true);
        this.wrapperInfo = injectionInfo;
        methodNode.visibleAnnotations.remove(annotationNode);
        this.originalAnnotation = (AnnotationNode)Annotations.getValue((AnnotationNode)annotationNode, (String)"original");
        methodNode.visibleAnnotations.add(this.originalAnnotation);
        this.sugarAnnotations = (List)Annotations.getValue((AnnotationNode)annotationNode, (String)"sugars");
        this.generics = new ArrayList(GenericParamParser.getParameterGenerics(methodNode.desc, (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"signature")));
        this.handler = this.prepareHandler(methodNode);
        this.sugarInjector = new SugarInjector(this.wrapperInfo, mixinTargetContext.getMixin(), this.handler, this.sugarAnnotations, this.generics);
        this.sugarInjector.stripSugar();
        this.delegate = InjectionInfo.parse((MixinTargetContext)mixinTargetContext, (MethodNode)this.handler);
        this.sugarInjector.setTargets(MixinInternals.getTargets(this.delegate));
        if (!this.isValid()) {
            this.sugarInjector.reSugarHandler();
        }
    }

    @Override
    public InjectionInfo getDelegate() {
        return this.delegate;
    }

    @Override
    public MethodNode getHandler() {
        return this.handler;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.sugarInjector.prepareSugar();
    }

    @Override
    public void granularInject(InjectorWrapperImpl$HandlerCallCallback injectorWrapperImpl$HandlerCallCallback) {
        HashMap hashMap = new HashMap();
        super.granularInject((target2, injectionNode, methodInsnNode) -> {
            injectorWrapperImpl$HandlerCallCallback.onFound(target2, injectionNode, methodInsnNode);
            hashMap.computeIfAbsent(target2, target -> new ArrayList()).add(Pair.of(injectionNode, methodInsnNode));
        });
        this.sugarInjector.reSugarHandler();
        this.sugarInjector.transformHandlerCalls(hashMap);
    }

    @Override
    public void doPostInject(Runnable runnable) {
        try {
            super.doPostInject(runnable);
            return;
        }
        catch (InjectionError | InvalidInjectionException throwable) {
            for (SugarApplicationException sugarApplicationException : this.sugarInjector.getExceptions()) {
                throwable.addSuppressed((Throwable)((Object)sugarApplicationException));
            }
            throw throwable;
        }
    }

    private MethodNode prepareHandler(MethodNode methodNode) {
        IMixinInfo iMixinInfo = CompatibilityHelper.getMixin(this.wrapperInfo).getMixin();
        HandlerInfo handlerInfo = SugarInjector.getHandlerInfo(iMixinInfo, methodNode, this.sugarAnnotations, this.generics);
        if (handlerInfo == null) {
            return methodNode;
        }
        iMixinInfo = new MethodNodeEx(methodNode.access, MethodNodeEx.getName((MethodNode)methodNode), methodNode.desc, methodNode.signature, methodNode.exceptions.toArray(new String[0]), iMixinInfo);
        methodNode.accept((MethodVisitor)iMixinInfo);
        methodNode.visibleAnnotations.remove(this.originalAnnotation);
        iMixinInfo.name = methodNode.name;
        iMixinInfo.tryCatchBlocks = null;
        iMixinInfo.visitAnnotation(Type.getDescriptor(SugarBridge.class), false);
        handlerInfo.transformHandler(this.classNode, (MethodNode)iMixinInfo);
        handlerInfo.transformGenerics(this.generics);
        this.classNode.methods.add(iMixinInfo);
        return iMixinInfo;
    }
}

