/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class ASMUtils {
    public static String annotationToString(AnnotationNode object) {
        StringBuilder stringBuilder = new StringBuilder("@").append(ASMUtils.typeToString(Type.getType((String)((AnnotationNode)object).desc)));
        object = ((AnnotationNode)object).values;
        if (object == null || object.isEmpty()) {
            return ((Object)stringBuilder).toString();
        }
        stringBuilder.append('(');
        for (int i2 = 0; i2 < object.size(); i2 += 2) {
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            String string = (String)object.get(i2);
            Object e2 = object.get(i2 + 1);
            stringBuilder.append(string).append(" = ").append(ASMUtils.valueToString(e2));
        }
        stringBuilder.append(')');
        return ((Object)stringBuilder).toString();
    }

    public static String typeToString(Type type) {
        String string = type.getClassName();
        return string.substring(string.lastIndexOf(46) + 1).replace('$', '.');
    }

    private static String valueToString(Object object) {
        block5: {
            while (true) {
                if (object instanceof String) {
                    return "\"" + object.toString() + '\"';
                }
                if (object instanceof Type) {
                    object = (Type)object;
                    return ASMUtils.typeToString((Type)object) + ".class";
                }
                if (object instanceof String[]) {
                    object = (String[])object;
                    return ASMUtils.typeToString(Type.getType((String)object[0])) + '.' + (String)object[1];
                }
                if (object instanceof AnnotationNode) {
                    return ASMUtils.annotationToString((AnnotationNode)object);
                }
                if (!(object instanceof List)) break block5;
                if ((object = (List)object).size() != 1) break;
                object = object.get(0);
            }
            return "{" + object.stream().map(ASMUtils::valueToString).collect(Collectors.joining(", ")) + '}';
        }
        return object.toString();
    }

    public static boolean isPrimitive(Type type) {
        return type.getDescriptor().length() == 1;
    }

    public static MethodInsnNode getInvokeInstruction(ClassNode classNode, MethodNode methodNode) {
        boolean bl;
        boolean bl2 = bl = (classNode.access & 0x200) != 0;
        int n2 = (methodNode.access & 8) != 0 ? 184 : ((methodNode.access & 2) != 0 ? 183 : (bl ? 185 : 182));
        return new MethodInsnNode(n2, classNode.name, methodNode.name, methodNode.desc, bl);
    }

    public static int getDummyOpcodeForType(Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 3;
            }
            case 6: {
                return 11;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 14;
            }
            case 9: 
            case 10: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static MethodInsnNode findInitNodeFor(Target object, TypeInsnNode typeInsnNode) {
        int n2 = object.indexOf((AbstractInsnNode)typeInsnNode);
        int n3 = 0;
        object = ((Target)object).insns.iterator(n2);
        while (object.hasNext()) {
            AbstractInsnNode abstractInsnNode = (AbstractInsnNode)object.next();
            if (abstractInsnNode instanceof TypeInsnNode && abstractInsnNode.getOpcode() == 187) {
                if (!((TypeInsnNode)abstractInsnNode).desc.equals(typeInsnNode.desc)) continue;
                ++n3;
                continue;
            }
            if (!(abstractInsnNode instanceof MethodInsnNode) || abstractInsnNode.getOpcode() != 183) continue;
            abstractInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!"<init>".equals(abstractInsnNode.name) || !abstractInsnNode.owner.equals(typeInsnNode.desc) || --n3 != 0) continue;
            return abstractInsnNode;
        }
        return null;
    }
}

