/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.capabilities.holder.chemical;

import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHolder;
import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustConfigChemicalTankHolder;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.AutomationType;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanAdjustChemicalTankHelper {
    private final IChemicalTankHolder slotHolder;
    private boolean built;

    private CanAdjustChemicalTankHelper(IChemicalTankHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static BiPredicate<ChemicalStack, @NotNull AutomationType> radioactiveInputTankPredicate(Supplier<IChemicalTank> outputTank) {
        return (type, automationType) -> automationType != AutomationType.EXTERNAL || ((IChemicalTank)outputTank.get()).isEmpty() && type.isRadioactive() && RadiationManager.isGlobalRadiationEnabled();
    }

    public static CanAdjustChemicalTankHelper forSide(Supplier<Direction> facingSupplier) {
        return CanAdjustChemicalTankHelper.forSide(facingSupplier, null, null);
    }

    public static CanAdjustChemicalTankHelper forSide(Supplier<Direction> facingSupplier, @Nullable Predicate<RelativeSide> insertPredicate, @Nullable Predicate<RelativeSide> extractPredicate) {
        return new CanAdjustChemicalTankHelper(new CanAdjustChemicalTankHolder(facingSupplier, insertPredicate, extractPredicate));
    }

    public static CanAdjustChemicalTankHelper forSideWithConfig(ISideConfiguration sideConfiguration) {
        return new CanAdjustChemicalTankHelper(new CanAdjustConfigChemicalTankHolder(sideConfiguration));
    }

    public IChemicalTank addTank(IChemicalTank tank) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IChemicalTankHolder iChemicalTankHolder = this.slotHolder;
        if (iChemicalTankHolder instanceof CanAdjustChemicalTankHolder) {
            CanAdjustChemicalTankHolder tankHolder = (CanAdjustChemicalTankHolder)iChemicalTankHolder;
            tankHolder.addTank(tank, new RelativeSide[0]);
        } else {
            iChemicalTankHolder = this.slotHolder;
            if (iChemicalTankHolder instanceof CanAdjustConfigChemicalTankHolder) {
                CanAdjustConfigChemicalTankHolder tankHolder = (CanAdjustConfigChemicalTankHolder)iChemicalTankHolder;
                tankHolder.addTank(tank);
            } else {
                throw new IllegalArgumentException("Holder does not know how to add tanks");
            }
        }
        return tank;
    }

    public IChemicalTank addTank(IChemicalTank tank, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IChemicalTankHolder iChemicalTankHolder = this.slotHolder;
        if (!(iChemicalTankHolder instanceof CanAdjustChemicalTankHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add tanks on specific sides");
        }
        CanAdjustChemicalTankHolder tankHolder = (CanAdjustChemicalTankHolder)iChemicalTankHolder;
        tankHolder.addTank(tank, sides);
        return tank;
    }

    public IChemicalTankHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

