/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.generator;

import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.tile.prefab.TileEntityMoreMachineGenerator;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.listener.ConfigBasedCachedLongSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeHeatGenerator
extends TileEntityMoreMachineGenerator
implements IBoundingBlock {
    public static final double HEAT_CAPACITY = 10.0;
    public static final double INVERSE_CONDUCTION_COEFFICIENT = 5.0;
    public static final double INVERSE_INSULATION_COEFFICIENT = 100.0;
    private static final double THERMAL_EFFICIENCY = 0.5;
    private static final ConfigBasedCachedLongSupplier MAX_PRODUCTION = new ConfigBasedCachedLongSupplier(() -> {
        long passiveMax = MoreMachineConfig.generators.largeHeatGenerationLava.get() * 81L;
        return (passiveMax += MoreMachineConfig.generators.largeHeatGenerationNether.get()) + MoreMachineConfig.generators.largeHeatGeneration.get();
    }, new CachedValue[]{MoreMachineConfig.generators.largeHeatGeneration, MoreMachineConfig.generators.largeHeatGenerationLava, MoreMachineConfig.generators.largeHeatGenerationNether});
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getLava", "getLavaCapacity", "getLavaNeeded", "getLavaFilledPercentage"}, docPlaceholder="lava tank")
    public BasicFluidTank lavaTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="generator")
    BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"}, docPlaceholder="fuel item slot")
    FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy item slot")
    EnergyInventorySlot energySlot;
    private long producingEnergy = 0L;
    private double efficiencyMultiplier = 1.0;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    private int numPowering;

    public TileEntityLargeHeatGenerator(BlockPos pos, BlockState state) {
        super((Holder<Block>)LargeMachineBlocks.LARGE_HEAT_GENERATOR, pos, state, (LongSupplier)MAX_PRODUCTION);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide((Supplier)this.facingSupplier);
        this.lavaTank = VariableCapacityFluidTank.input((IntSupplier)MoreMachineConfig.generators.largeHeatTankCapacity, fluidStack -> fluidStack.is(FluidTags.LAVA), (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.lavaTank, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.lavaTank, stack -> stack.getBurnTime(null) / 20, size -> new FluidStack((Fluid)Fluids.LAVA, size), (IContentsListener)listener, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide((Supplier)this.facingSupplier);
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)5.0, (double)100.0, (DoubleSupplier)ambientTemperature, (IContentsListener)listener);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.BACK};
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        long prev = this.getEnergyContainer().getEnergy();
        this.heatCapacitor.handleHeat(this.getBoost());
        if (this.canFunction() && this.getEnergyContainer().getNeeded() > 0L) {
            double fluidRatio = (double)this.lavaTank.getFluidAmount() / (double)this.lavaTank.getCapacity();
            this.efficiencyMultiplier = (int)Math.max(1.0, Math.pow(10.0, fluidRatio * 2.0));
            int fluidRate = (int)(this.efficiencyMultiplier * (double)MoreMachineConfig.generators.largeHeatGenerationFluidRate.get());
            if (this.lavaTank.extract(fluidRate, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == fluidRate) {
                this.setActive(true);
                this.lavaTank.extract(fluidRate, Action.EXECUTE, AutomationType.INTERNAL);
                this.heatCapacitor.handleHeat((double)MoreMachineConfig.generators.largeHeatGeneration.get() * this.efficiencyMultiplier);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.adjacentTransfer();
        this.lastEnvironmentLoss = loss.environmentTransfer();
        this.producingEnergy = this.getEnergyContainer().getEnergy() - prev;
        this.updateMaxOutputRaw(this.producingEnergy + MAX_PRODUCTION.getAsLong());
        return sendUpdatePacket;
    }

    @Override
    protected BlockPos offSetOutput(BlockPos from, Direction side) {
        Direction back = this.getOppositeDirection();
        return from.offset(new Vec3i(back.getStepX(), 1, back.getStepZ())).relative(side);
    }

    private double getBoost() {
        long boost;
        if (this.level == null) {
            return 0.0;
        }
        long passiveLavaAmount = MoreMachineConfig.generators.largeHeatGenerationLava.get();
        if (passiveLavaAmount == 0L) {
            boost = 0L;
        } else {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int lavaSides = 0;
            for (int x = -2; x <= 2; ++x) {
                for (int y = -1; y <= 3; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        int edgeCount = 0;
                        if (x == -2 || x == 2) {
                            ++edgeCount;
                        }
                        if (y == -1 || y == 3) {
                            ++edgeCount;
                        }
                        if (z == -2 || z == 2) {
                            ++edgeCount;
                        }
                        if (edgeCount > 1) continue;
                        mutable.setWithOffset((Vec3i)this.worldPosition, x, y, z);
                        if (!WorldUtils.getFluidState((BlockGetter)this.level, (BlockPos)mutable).filter(state -> state.is(FluidTags.LAVA)).isPresent()) continue;
                        ++lavaSides;
                    }
                }
            }
            if (this.getBlockState().getFluidState().is(FluidTags.LAVA)) {
                ++lavaSides;
            }
            boost = passiveLavaAmount * (long)lavaSides;
        }
        if (this.level.dimensionType().ultraWarm()) {
            boost += MoreMachineConfig.generators.largeHeatGenerationNether.get();
        }
        return boost;
    }

    public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getInverseInsulation(capacitor, side);
    }

    public double getTotalInverseInsulation(@Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getTotalInverseInsulation(side);
    }

    @NotNull
    public HeatAPI.HeatTransfer simulate() {
        double ambientTemp = this.ambientTemperature.getAsDouble();
        double temp = this.getTotalTemperature();
        double carnotEfficiency = 1.0 - Math.min(ambientTemp, temp) / Math.max(ambientTemp, temp);
        double heatLost = 0.5 * (temp - ambientTemp);
        this.heatCapacitor.handleHeat(-heatLost);
        long energyFromHeat = MathUtils.clampToLong((double)(Math.abs(heatLost) * carnotEfficiency));
        this.getEnergyContainer().insert((long)((double)Math.min(energyFromHeat, MAX_PRODUCTION.getAsLong()) * this.efficiencyMultiplier), Action.EXECUTE, AutomationType.INTERNAL);
        return super.simulate();
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        return side == Direction.DOWN ? this.getAdjacentUnchecked(side) : null;
    }

    @Override
    public long getProductionRate() {
        return this.producingEnergy;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.lavaTank.getFluidAmount(), (long)this.lavaTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableLong.create(this::getProductionRate, value -> {
            this.producingEnergy = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 2, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ENERGY.block()) {
            return (T)Objects.requireNonNull(this.energyHandlerManager, "Expected to have energy handler").resolve(capability, side);
        }
        if (capability == Capabilities.FLUID.block()) {
            return (T)Objects.requireNonNull(this.fluidHandlerManager, "Expected to have fluid handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        if (capability == Capabilities.HEAT) {
            return (T)Objects.requireNonNull(this.heatHandlerManager, "Expected to have heat handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.FLUID.block()) {
            return this.notFluidPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        if (capability == Capabilities.HEAT) {
            return this.notHeatPort(side, offset);
        }
        return this.notFluidPort(side, offset) && this.notHeatPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notHeatPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 2, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    private boolean notFluidPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ())) || offset.equals((Object)new Vec3i(back.getStepX(), 2, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notFluidPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 1, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }
}

