/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.machine;

import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHelper;
import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.meklm.common.tile.INeedConfig;
import com.jerry.mekmm.common.util.WorldUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.SingleChemicalRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeSolarNeutronActivator
extends TileEntityRecipeMachine<ChemicalToChemicalRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<ChemicalToChemicalRecipe>,
INeedConfig {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final long MAX_GAS = 10000000L;
    protected LargeSNA solarCheck;
    private final LargeSNA[] solarChecks = new LargeSNA[8];
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public IChemicalTank inputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output tank")
    public IChemicalTank outputTank;
    @SyntheticComputerMethod(getter="getProductionRate")
    private float productionRate;
    private int baselineMaxOperations = 1;
    private int numPowering;
    private byte seeSunCount = 0;
    private final IOutputHandler<@NotNull ChemicalStack> outputHandler;
    private final IInputHandler<@NotNull ChemicalStack> inputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    ChemicalInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    ChemicalInventorySlot outputSlot;

    public TileEntityLargeSolarNeutronActivator(BlockPos pos, BlockState state) {
        super(LargeMachineBlocks.LARGE_SOLAR_NEUTRON_ACTIVATOR, pos, state, TRACKED_ERROR_TYPES);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inputSlot, (Object)this.outputSlot, RelativeSide.FRONT);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.inputTank, (Object)this.outputTank, RelativeSide.FRONT, false, true);
        this.configComponent.addDisabledSides(new RelativeSide[]{RelativeSide.TOP});
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> tank != this.inputTank);
        this.inputHandler = InputHelper.getInputHandler((IChemicalTank)this.inputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustChemicalTankHelper builder = CanAdjustChemicalTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.RIGHT || side == RelativeSide.LEFT, side -> side == RelativeSide.BACK);
        this.inputTank = BasicChemicalTank.createModern((long)10000000L, (BiPredicate)ChemicalTankHelper.radioactiveInputTankPredicate(() -> this.outputTank), (BiPredicate)ConstantPredicates.alwaysTrueBi(), arg_0 -> ((TileEntityLargeSolarNeutronActivator)this).containsRecipe(arg_0), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)recipeCacheListener);
        builder.addTank(this.inputTank, RelativeSide.RIGHT, RelativeSide.LEFT);
        this.outputTank = BasicChemicalTank.output((long)10000000L, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank(this.outputTank, RelativeSide.BACK);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier, side -> side == RelativeSide.RIGHT || side == RelativeSide.LEFT, side -> side == RelativeSide.BACK);
        this.inputSlot = ChemicalInventorySlot.fill((IChemicalTank)this.inputTank, (IContentsListener)listener, (int)5, (int)56);
        builder.addSlot((IInventorySlot)this.inputSlot, new RelativeSide[]{RelativeSide.RIGHT, RelativeSide.LEFT});
        this.outputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.outputTank, (IContentsListener)listener, (int)155, (int)56);
        builder.addSlot((IInventorySlot)this.outputSlot, new RelativeSide[]{RelativeSide.BACK});
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    private void recheckSettings() {
        if (this.level == null) {
            return;
        }
        BlockPos topPos = this.worldPosition.above(2);
        this.solarCheck = new LargeSNA(this.level, topPos);
        for (int i = 0; i < this.solarChecks.length; ++i) {
            this.solarChecks[i] = i < 3 ? new LargeSNA(this.level, topPos.offset(-1, 0, i - 1)) : (i == 3 ? new LargeSNA(this.level, topPos.offset(0, 0, -1)) : (i == 4 ? new LargeSNA(this.level, topPos.offset(0, 0, 1)) : new LargeSNA(this.level, topPos.offset(1, 0, i - 6))));
        }
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.solarCheck == null) {
            this.recheckSettings();
        }
        this.updateSeeSunCount();
        this.inputSlot.fillTank();
        this.outputSlot.drainTank();
        this.productionRate = this.recalculateProductionRate();
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    private void updateSeeSunCount() {
        this.solarCheck.recheckCanSeeSun();
        byte count = this.solarCheck.canSeeSun() ? (byte)1 : 0;
        for (LargeSNA check : this.solarChecks) {
            check.recheckCanSeeSun();
            if (!check.canSeeSun()) continue;
            count = (byte)(count + 1);
        }
        this.seeSunCount = count;
    }

    @Override
    public boolean needConfig() {
        return false;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<SingleChemicalRecipeInput, ChemicalToChemicalRecipe, InputRecipeCache.SingleChemical<ChemicalToChemicalRecipe>> getRecipeType() {
        return MekanismRecipeType.ACTIVATING;
    }

    public IRecipeViewerRecipeType<ChemicalToChemicalRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.ACTIVATING;
    }

    @Nullable
    public ChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return (ChemicalToChemicalRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @ComputerMethod
    boolean canSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        return this.seeSunCount > 0;
    }

    private float reduceMultiplier() {
        int panelCount = this.solarChecks.length + 1;
        byte notSeeSunCount = (byte)(panelCount - this.seeSunCount);
        if (notSeeSunCount <= 0) {
            return 0.0f;
        }
        if (notSeeSunCount >= panelCount) {
            return 1.0f;
        }
        float reduction = notSeeSunCount <= 3 ? 0.05f * (float)notSeeSunCount + 0.8f : (notSeeSunCount <= 7 ? 0.1f * (float)notSeeSunCount + 0.4f : 0.4f);
        return reduction;
    }

    public boolean canFunction() {
        return super.canFunction() && this.canSeeSun();
    }

    private float recalculateProductionRate() {
        if (this.level == null || !this.canFunction() || this.solarCheck == null) {
            return 0.0f;
        }
        float brightness = WorldUtils.getSunBrightness((Level)this.level, (float)1.0f);
        float generationMultiplier = this.solarCheck.getProductionMultiplier();
        for (LargeSNA check : this.solarChecks) {
            generationMultiplier += check.getProductionMultiplier();
        }
        return (float)MekanismConfig.general.maxSolarNeutronActivatorRate.get() * (generationMultiplier /= (float)(this.solarChecks.length + 1)) * brightness * (1.0f - this.reduceMultiplier());
    }

    @NotNull
    public CachedRecipe<ChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull ChemicalToChemicalRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.chemicalToChemical((ChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(this::canFunction).setActive(arg_0 -> ((TileEntityLargeSolarNeutronActivator)this).setActive(arg_0)).setOnFinish(() -> ((TileEntityLargeSolarNeutronActivator)this).markForSave()).setRequiredTicks(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? Mth.ceil((float)(1.0f / this.productionRate)) : 1).setBaselineMaxOperations(() -> this.baselineMaxOperations * (this.productionRate > 0.0f && this.productionRate < 1.0f ? 1 : (int)this.productionRate));
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.baselineMaxOperations = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        }
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.inputTank.getStored(), (long)this.inputTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction direction = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ())) && !offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ())) && !offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return (T)Objects.requireNonNull(this.chemicalHandlerManager, "Expected to have chemical handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return this.notChemicalPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        return this.notChemicalPort(side, offset) && this.notItemPort(side, offset);
    }

    private boolean notChemicalPort(Direction side, Vec3i offset) {
        Direction direction = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                if (offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return side != back && side != right;
            }
            case WEST: 
            case EAST: {
                if (offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return side != back && side != right;
            }
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notChemicalPort(side, offset);
    }

    protected static class LargeSNA
    extends WorldUtil.SolarCheck {
        private final int recheckFrequency;
        private long lastCheckedSun;

        public LargeSNA(Level world, BlockPos pos) {
            super(world, pos);
            this.recheckFrequency = Mth.nextInt((RandomSource)world.random, (int)10, (int)30);
        }

        @Override
        public void recheckCanSeeSun() {
            BlockState state;
            BlockPos above;
            if (!this.world.dimensionType().hasSkyLight() || this.world.getSkyDarken() >= 4) {
                this.canSeeSun = false;
                return;
            }
            long time = this.world.getGameTime();
            if (time < this.lastCheckedSun + (long)this.recheckFrequency) {
                return;
            }
            this.lastCheckedSun = time;
            this.canSeeSun = this.world.getFluidState(this.pos).isEmpty() ? this.world.canSeeSky(this.pos) : (this.world.canSeeSky(above = this.pos.above()) ? !(state = this.world.getBlockState(above)).liquid() && state.getLightBlock((BlockGetter)this.world, above) <= 0 : false);
        }
    }
}

