/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import com.jerry.mekmm.api.recipes.MoreMachineRecipeSerializers;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicPlantingRecipe
extends PlantingRecipe {
    public final ItemStackIngredient itemInput;
    public final ChemicalStackIngredient chemicalInput;
    public final ItemStack mainOutput;
    public final ItemStack secondaryOutput;
    private final boolean perTickUsage;

    public BasicPlantingRecipe(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack mainOutput, ItemStack secondaryOutput, boolean perTickUsage) {
        this.itemInput = Objects.requireNonNull(itemInput, "Input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        if (mainOutput.isEmpty()) {
            throw new IllegalArgumentException("Main output cannot be null.");
        }
        this.mainOutput = mainOutput.copy();
        this.secondaryOutput = secondaryOutput.copy();
        this.perTickUsage = perTickUsage;
    }

    public boolean test(@NotNull ItemStack itemStack, ChemicalStack chemicalStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(chemicalStack);
    }

    public boolean perTickUsage() {
        return this.perTickUsage;
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    public List<PlantingRecipe.PlantingStationRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new PlantingRecipe.PlantingStationRecipeOutput(this.mainOutput, this.secondaryOutput));
    }

    public ItemStack getMainOutput() {
        return this.mainOutput;
    }

    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput.isEmpty() ? ItemStack.EMPTY : this.secondaryOutput;
    }

    @Contract(value="_, _ -> new", pure=true)
    public PlantingRecipe.PlantingStationRecipeOutput getOutput(ItemStack solid, ChemicalStack chemical) {
        return new PlantingRecipe.PlantingStationRecipeOutput(this.mainOutput.copy(), this.secondaryOutput.copy());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MoreMachineRecipeSerializers.PLANTING.get();
    }
}

