/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ItemStackChemicalToObjectRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MMItemStackConstantChemicalToObjectCachedRecipe<OUTPUT, RECIPE extends ItemStackChemicalToObjectRecipe<OUTPUT>>
extends CachedRecipe<RECIPE> {
    protected final Predicate<OUTPUT> outputEmptyCheck;
    protected final IOutputHandler<@NotNull OUTPUT> outputHandler;
    protected final IInputHandler<@NotNull ItemStack> itemInputHandler;
    protected final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    protected final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsage;
    protected final LongConsumer chemicalUsedSoFarChanged;
    protected long chemicalUsageMultiplier;
    protected long chemicalUsedSoFar;
    protected ItemStack recipeItem = ItemStack.EMPTY;
    @Nullable
    protected ChemicalStack recipeChemical;
    @Nullable
    protected OUTPUT output;

    public MMItemStackConstantChemicalToObjectCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<ChemicalStack> chemicalInputHandler, ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<@NotNull OUTPUT> outputHandler, Predicate<OUTPUT> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.chemicalUsage = Objects.requireNonNull(chemicalUsage, "Chemical usage cannot be null.");
        this.chemicalUsedSoFarChanged = Objects.requireNonNull(chemicalUsedSoFarChanged, "Chemical used so far changed handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    public void loadSavedUsageSoFar(long chemicalUsedSoFar) {
        if (chemicalUsedSoFar > 0L) {
            this.chemicalUsedSoFar = chemicalUsedSoFar;
        }
    }

    protected void setupVariableValues() {
        this.chemicalUsageMultiplier = Math.max(this.chemicalUsage.getToUse(this.chemicalUsedSoFar, this.getOperatingTicks()), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getItemInput());
            if (this.recipeItem.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getChemicalInput());
                if (this.recipeChemical.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeChemical.isEmpty() && tracker.shouldContinueChecking()) {
                    this.chemicalInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeChemical, this.chemicalUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((ItemStackChemicalToObjectRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical);
                        this.outputHandler.calculateOperationsCanSupport(tracker, this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        ChemicalStack chemicalStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.isEmpty() && !(chemicalStack = (ChemicalStack)this.chemicalInputHandler.getInput()).isEmpty() && ((ItemStackChemicalToObjectRecipe)this.recipe).test(itemInput, chemicalStack)) {
            ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getChemicalInput());
            return !recipeChemical.isEmpty() && chemicalStack.getAmount() >= recipeChemical.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.chemicalUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeChemical == null || this.recipeChemical.isEmpty()) {
            return;
        }
        long toUse = (long)operations * this.chemicalUsageMultiplier;
        this.chemicalInputHandler.use((Object)this.recipeChemical, toUse);
        this.chemicalUsedSoFar += toUse;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    protected void resetCache() {
        super.resetCache();
        this.chemicalUsedSoFar = 0L;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeChemical == null || this.output == null || this.recipeItem.isEmpty() || this.recipeChemical.isEmpty() || this.outputEmptyCheck.test(this.output))) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            if (this.chemicalUsageMultiplier > 0L) {
                this.chemicalInputHandler.use((Object)this.recipeChemical, (long)operations * this.chemicalUsageMultiplier);
            }
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

