/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.cache;

import com.jerry.mekmm.api.recipes.StamperRecipe;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StamperCachedRecipe
extends CachedRecipe<StamperRecipe> {
    private final IInputHandler<ItemStack> inputHandler;
    private final IInputHandler<ItemStack> secondaryInputHandler;
    private final IOutputHandler<ItemStack> outputHandler;
    private final Predicate<ItemStack> inputEmptyCheck;
    private final Predicate<ItemStack> secondaryInputEmptyCheck;
    private final Supplier<? extends InputIngredient<ItemStack>> inputSupplier;
    private final Supplier<? extends InputIngredient<ItemStack>> secondaryInputSupplier;
    private final BiFunction<ItemStack, ItemStack, ItemStack> outputGetter;
    private final Predicate<ItemStack> outputEmptyCheck;
    private final BiConsumer<ItemStack, ItemStack> inputsSetter;
    private final Consumer<ItemStack> outputSetter;
    @Nullable
    private ItemStack input;
    @Nullable
    private ItemStack secondaryInput;
    @Nullable
    private ItemStack output;

    protected StamperCachedRecipe(StamperRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<ItemStack> inputHandler, IInputHandler<ItemStack> secondaryInputHandler, IOutputHandler<ItemStack> outputHandler, Supplier<InputIngredient<ItemStack>> inputSupplier, Supplier<InputIngredient<ItemStack>> secondaryInputSupplier, BiFunction<ItemStack, ItemStack, ItemStack> outputGetter, Predicate<ItemStack> inputEmptyCheck, Predicate<ItemStack> secondaryInputEmptyCheck, Predicate<ItemStack> outputEmptyCheck) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.secondaryInputHandler = Objects.requireNonNull(secondaryInputHandler, "Secondary input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.secondaryInputSupplier = Objects.requireNonNull(secondaryInputSupplier, "Secondary input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.secondaryInputEmptyCheck = Objects.requireNonNull(secondaryInputEmptyCheck, "Secondary input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
        this.inputsSetter = (input, secondary) -> {
            this.input = input;
            this.secondaryInput = secondary;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
    }

    public static StamperCachedRecipe createCache(StamperRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> inputHandler, IInputHandler<@NotNull ItemStack> extraInputHandler, IOutputHandler<@NotNull ItemStack> outputHandler) {
        return new StamperCachedRecipe(recipe, recheckAllErrors, inputHandler, extraInputHandler, outputHandler, recipe::getInput, recipe::getMold, recipe::getOutput, ConstantPredicates.ITEM_EMPTY, ConstantPredicates.ITEM_EMPTY, ConstantPredicates.ITEM_EMPTY);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        CachedRecipeHelper.twoInputCalculateOperationsThisTick((CachedRecipe.OperationTracker)tracker, this.inputHandler, this.inputSupplier, this.secondaryInputHandler, this.secondaryInputSupplier, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, this.inputEmptyCheck, this.secondaryInputEmptyCheck);
    }

    public boolean isInputValid() {
        ItemStack input = (ItemStack)this.inputHandler.getInput();
        if (this.inputEmptyCheck.test(input)) {
            return false;
        }
        ItemStack secondaryInput = (ItemStack)this.secondaryInputHandler.getInput();
        return !this.secondaryInputEmptyCheck.test(secondaryInput) && ((StamperRecipe)this.recipe).test(input, secondaryInput);
    }

    protected void finishProcessing(int operations) {
        if (!(this.input == null || this.secondaryInput == null || this.output == null || this.inputEmptyCheck.test(this.input) || this.secondaryInputEmptyCheck.test(this.secondaryInput) || this.outputEmptyCheck.test(this.output))) {
            this.inputHandler.use((Object)this.input, operations);
            this.outputHandler.handleOutput((Object)this.output, operations);
        }
    }
}

