/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.attachments.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.StreamCodec;

public record ConnectionConfig(BlockPos pos, Direction direction, TransmissionType type) {
    public static final Codec<ConnectionConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ConnectionConfig::pos), (App)Direction.CODEC.fieldOf("direction").forGetter(ConnectionConfig::direction), (App)TransmissionType.CODEC.fieldOf("type").forGetter(ConnectionConfig::type)).apply((Applicative)instance, ConnectionConfig::new));
    public static final StreamCodec<ByteBuf, ConnectionConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ConnectionConfig::pos, (StreamCodec)Direction.STREAM_CODEC, ConnectionConfig::direction, (StreamCodec)TransmissionType.STREAM_CODEC, ConnectionConfig::type, ConnectionConfig::new);

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putLong("pos", this.pos.asLong());
        tag.putByte("direction", (byte)this.direction.ordinal());
        tag.putByte("type", (byte)this.type.ordinal());
        return tag;
    }

    public static ConnectionConfig fromNBT(CompoundTag tag) {
        BlockPos pos = BlockPos.of((long)tag.getLong("pos"));
        Direction dir = Direction.values()[tag.getByte("direction")];
        TransmissionType type = TransmissionType.values()[tag.getByte("type")];
        return new ConnectionConfig(pos, dir, type);
    }
}

