/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.network.to_server.button;

import com.jerry.mekmm.Mekmm;
import com.jerry.mekmm.common.MoreMachineLang;
import com.jerry.mekmm.common.registries.MoreMachineContainerTypes;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MoreMachinePacketTileButtonPress(MoreMachineClickedTileButton buttonClicked, BlockPos pos) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<MoreMachinePacketTileButtonPress> TYPE = new CustomPacketPayload.Type(Mekmm.rl("tile_button"));
    public static final StreamCodec<ByteBuf, MoreMachinePacketTileButtonPress> STREAM_CODEC = StreamCodec.composite(MoreMachineClickedTileButton.STREAM_CODEC, MoreMachinePacketTileButtonPress::buttonClicked, (StreamCodec)BlockPos.STREAM_CODEC, MoreMachinePacketTileButtonPress::pos, MoreMachinePacketTileButtonPress::new);

    public MoreMachinePacketTileButtonPress(MoreMachineClickedTileButton buttonClicked, BlockEntity tile) {
        this(buttonClicked, tile.getBlockPos());
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.pos);
        MenuProvider provider = this.buttonClicked.getProvider(tile);
        if (provider != null) {
            player.openMenu(provider, buf -> {
                buf.writeBlockPos(this.pos);
                this.buttonClicked.encodeExtraData((RegistryFriendlyByteBuf)buf, tile);
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum MoreMachineClickedTileButton {
        WIRELESS_TRANSMISSION_STATION_CONFIG(tile -> MoreMachineContainerTypes.WIRELESS_TRANSMISSION_STATION_CONFIG.getProvider((ILangEntry)MoreMachineLang.TRANSMITTER_CONFIG, tile));

        public static final IntFunction<MoreMachineClickedTileButton> BY_ID;
        public static final StreamCodec<ByteBuf, MoreMachineClickedTileButton> STREAM_CODEC;
        private final Function<TileEntityMekanism, @Nullable MenuProvider> providerFromTile;
        @Nullable
        private final BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData;

        private MoreMachineClickedTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile) {
            this(providerFromTile, null);
        }

        private MoreMachineClickedTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile, BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData) {
            this.providerFromTile = providerFromTile;
            this.extraEncodingData = extraEncodingData;
        }

        @Nullable
        @Contract(value="null -> null")
        public MenuProvider getProvider(@Nullable TileEntityMekanism tile) {
            return tile == null ? null : this.providerFromTile.apply(tile);
        }

        private void encodeExtraData(RegistryFriendlyByteBuf buffer, TileEntityMekanism tile) {
            if (this.extraEncodingData != null) {
                this.extraEncodingData.accept(buffer, tile);
            }
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])MoreMachineClickedTileButton.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

