/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.energy.EnergyContainer;

public record RecordEnergyContainer(int[] slots, int capacity, @Nullable Runnable updateCallback) implements EnergyContainer
{
    public RecordEnergyContainer(int[] slots, int capacity, @Nullable Runnable updateCallback) {
        Objects.requireNonNull(slots);
        Objects.checkIndex(0, slots.length);
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be greater than 0");
        }
    }

    public static RecordEnergyContainer simple() {
        return RecordEnergyContainer.of(1, 1000);
    }

    public static RecordEnergyContainer of(int size, int capacity) {
        return RecordEnergyContainer.of(size, capacity, null);
    }

    public static RecordEnergyContainer of(int size, int capacity, @Nullable Runnable updateCallback) {
        return new RecordEnergyContainer(new int[size], capacity, updateCallback);
    }

    public static RecordEnergyContainer from(int[] values, int capacity) {
        return RecordEnergyContainer.from(values, capacity, null);
    }

    public static RecordEnergyContainer from(int[] values, int capacity, Runnable updateCallback) {
        return new RecordEnergyContainer((int[])values.clone(), capacity, updateCallback);
    }

    @Override
    public int size() {
        return this.slots.length;
    }

    @Override
    public int getCapacity(int slot) {
        Objects.checkIndex(slot, this.size());
        return this.capacity;
    }

    @Override
    public int get(int slot) {
        Objects.checkIndex(slot, this.size());
        return this.slots[slot];
    }

    @Override
    public void set(int slot, int value) {
        Objects.checkIndex(slot, this.size());
        this.slots[slot] = value;
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.slots, 0);
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    @Override
    @Contract(pure=true)
    public int @NotNull [] copyContents() {
        return (int[])this.slots.clone();
    }

    @Override
    @NotNull
    public EnergyContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new Slice(from, to - from);
    }

    private class Slice
    implements EnergyContainer {
        private final int start;
        private final int length;

        public Slice(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public int get(int slot) {
            Objects.checkIndex(slot, this.size());
            return RecordEnergyContainer.this.get(slot + this.start);
        }

        @Override
        public void set(int slot, int value) {
            Objects.checkIndex(slot, this.size());
            RecordEnergyContainer.this.set(slot + this.start, value);
        }

        @Override
        public int getCapacity(int slot) {
            Objects.checkIndex(slot, this.size());
            return RecordEnergyContainer.this.getCapacity(slot + this.start);
        }

        @Override
        public void clear() {
            RecordEnergyContainer.this.clear();
        }

        @Override
        @NotNull
        public EnergyContainer slice(int from, int to) {
            Objects.checkFromToIndex(from, to, this.length);
            return new Slice(this.start + from, to - from);
        }
    }
}

