/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.container;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.container.item2.ItemContainerToVanillaAdapter;
import tv.soaryn.xycraft.core.container.resource.MutableResourceStack;
import tv.soaryn.xycraft.core.container.resource.ResourceListContainer;
import tv.soaryn.xycraft.core.utils.protocontainer.ItemResource;

public class SimpleResourceItemContainer
extends ResourceListContainer<ItemResource> {
    public SimpleResourceItemContainer(NonNullList<MutableResourceStack<ItemResource>> mutableResourceStacks, @Nullable Runnable updateCallback) {
        super(mutableResourceStacks, updateCallback, MutableResourceStack.Empty.ITEM);
    }

    public static SimpleResourceItemContainer of(int size) {
        return SimpleResourceItemContainer.of(size, null);
    }

    public static SimpleResourceItemContainer of(int size, @Nullable Runnable updateCallback) {
        return new SimpleResourceItemContainer(MutableResourceStack.Empty.ITEM.nonNullListOfSize(size), updateCallback);
    }

    public static SimpleResourceItemContainer from(NonNullList<MutableResourceStack<ItemResource>> items) {
        return SimpleResourceItemContainer.from(items, null);
    }

    public static SimpleResourceItemContainer from(NonNullList<MutableResourceStack<ItemResource>> items, Runnable updateCallback) {
        SimpleResourceItemContainer container = SimpleResourceItemContainer.of(items.size(), updateCallback);
        for (int i = 0; i < items.size(); ++i) {
            container.set(i, (MutableResourceStack)items.get(i));
        }
        return container;
    }

    @Override
    public int getCapacity(int index) {
        return 99;
    }

    @Override
    public int getCapacity(int index, @NotNull ItemResource resource) {
        return Math.min(resource.getMaxStackSize(), this.getCapacity(index));
    }

    @Contract(pure=true)
    @NotNull
    public Container asVanillaContainer() {
        return new ItemContainerToVanillaAdapter(this);
    }
}

