/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.IContent;
import tv.soaryn.xycraft.core.datagen.BlockModelType;

public class BlockContent
implements IContent<BlockContent>,
ItemLike {
    private final DeferredBlock<Block> _registryBlock;
    private final DeferredItem<Item> _registryItem;
    private final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> _registryEntity;
    private String _modelPath;
    protected final HashMap<String, String> _localizations = new HashMap();
    private BlockModelType _modelType;
    private boolean _customBreakRules;
    private boolean _customItemModel;
    private int _color = -1;
    private int _emissivity = -1;
    private boolean _hasDynamicColor;
    private BooleanSupplier _requirement = () -> true;
    private DeferredHolder<CreativeModeTab, CreativeModeTab> _tab;

    public BlockContent(DeferredBlock<Block> block, DeferredItem<Item> item) {
        this(block, item, null);
        this._color = -1;
    }

    public BlockContent(DeferredBlock<Block> block, DeferredItem<Item> item, DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> entity) {
        this._registryBlock = block;
        this._registryItem = item;
        this._modelPath = this._registryBlock.getId().getPath();
        this._modelType = BlockModelType.Simple;
        this._registryEntity = entity;
    }

    public Block block() {
        return (Block)this._registryBlock.get();
    }

    public Item item() {
        return (Item)this._registryItem.get();
    }

    public <T extends BlockEntity> BlockEntityType<T> entity() {
        return (BlockEntityType)this._registryEntity.value();
    }

    public BlockContent withModelType(BlockModelType type) {
        this._modelType = type;
        return this;
    }

    @Override
    public BlockContent requires(BooleanSupplier requirement) {
        this._requirement = requirement;
        return this;
    }

    @Override
    public boolean hasPrerequisites() {
        return this._requirement.getAsBoolean();
    }

    public BlockContent withCustomBreakRule() {
        this._customBreakRules = true;
        return this;
    }

    public BlockContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    public BlockContent withColor(int color) {
        this._color = color;
        return this;
    }

    public BlockContent withEmissivity(int value) {
        this._emissivity = value;
        return this;
    }

    public int getEmissivity() {
        return this._emissivity;
    }

    public BlockContent withDynamicColor() {
        this._hasDynamicColor = true;
        return this;
    }

    public int getColor() {
        return this._color;
    }

    public BlockModelType getModelType() {
        return this._modelType;
    }

    public boolean hasCustomBreakRules() {
        return this._customBreakRules;
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }

    @Override
    public ResourceLocation id() {
        return this._registryBlock.getId();
    }

    @Override
    public BlockContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public BlockContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public DeferredHolder<CreativeModeTab, CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public BlockContent setTab(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    @NotNull
    public Item asItem() {
        return this.item();
    }
}

