/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.IContent;

public class ItemContent
implements IContent<ItemContent>,
ItemLike {
    private final DeferredItem<Item> _registryItem;
    private String _modelPath;
    private final HashMap<String, String> _localizations = new HashMap();
    private boolean _customItemModel;
    private DeferredHolder<CreativeModeTab, CreativeModeTab> _tab;
    private BooleanSupplier _requirement = () -> true;

    public ItemContent(DeferredItem<Item> item) {
        this._registryItem = item;
        this._modelPath = item.getId().getPath();
        this._localizations.put("en_us", item.getId().getPath());
    }

    public ItemContent withTempModel() {
        return this.withModelPath("temp");
    }

    public ItemContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    @Override
    public ItemContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    @Override
    public ItemContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    @Override
    public ItemContent requires(BooleanSupplier requirement) {
        this._requirement = requirement;
        return this;
    }

    @Override
    public boolean hasPrerequisites() {
        return this._requirement.getAsBoolean();
    }

    @Override
    public ResourceLocation id() {
        return this._registryItem.getId();
    }

    public Item item() {
        return (Item)this._registryItem.value();
    }

    @Override
    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }

    @Override
    public String modelPath() {
        return this._modelPath;
    }

    @Override
    public DeferredHolder<CreativeModeTab, CreativeModeTab> tab() {
        return this._tab;
    }

    @Override
    public ItemContent setTab(DeferredHolder<CreativeModeTab, CreativeModeTab> tab) {
        this._tab = tab;
        return this;
    }

    @NotNull
    public Item asItem() {
        return this.item();
    }

    public ItemStack stack() {
        return this.item().getDefaultInstance();
    }
}

