/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.DyeColors;

public class ColoredBlock
extends XyBlock
implements IColoredBlock {
    public final IColorSource ColorSource;
    protected final MapColor mapColor;
    private static final MapColor[] colorPool = new MapColor[]{MapColor.SNOW, MapColor.COLOR_ORANGE, MapColor.COLOR_MAGENTA, MapColor.COLOR_LIGHT_BLUE, MapColor.COLOR_YELLOW, MapColor.COLOR_LIGHT_GREEN, MapColor.COLOR_PINK, MapColor.COLOR_GRAY, MapColor.COLOR_LIGHT_GRAY, MapColor.COLOR_CYAN, MapColor.COLOR_PURPLE, MapColor.COLOR_BLUE, MapColor.COLOR_BROWN, MapColor.COLOR_GREEN, MapColor.COLOR_RED, MapColor.COLOR_BLACK};

    public ColoredBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(properties.isValidSpawn((state, level, pos, entityType) -> entityType == EntityType.PLAYER || (Boolean)state.getValue((Property)CoreStateProperties.Spawnable) != false));
        this.ColorSource = color;
        this.mapColor = ColoredBlock.getClosestMaterialColor(color.getColor());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false)));
    }

    public static ColoredBlock noTint(IColorSource color, BlockBehaviour.Properties properties) {
        return new ColoredBlock(new ColorSource.Arbitrary(-1), properties);
    }

    public static MapColor getClosestMaterialColor(int color) {
        MapColor closest = MapColor.NONE;
        double currentDif = 2.147483647E9;
        Vector3f colorVec = ColorUtils.convertToRGBVec(color);
        for (MapColor materialColor : colorPool) {
            Vector3f materialColorVec = ColorUtils.convertToRGBVec(materialColor.col);
            double distance = colorVec.distance((Vector3fc)materialColorVec);
            if (!(distance < currentDif)) continue;
            currentDif = distance;
            closest = materialColor;
        }
        return closest;
    }

    @NotNull
    public MapColor getMapColor(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull MapColor defaultColor) {
        return this.mapColor;
    }

    public static Supplier<Block> supplier(IColorSource color) {
        return () -> new ColoredBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().strength(Blocks.STONE.defaultDestroyTime()));
    }

    public static Supplier<Block> supplier() {
        return ColoredBlock.supplier(new ColorSource.Arbitrary(-1));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CoreStateProperties.Spawnable});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemInteractionResult interactionResult = ColoredBlock.tryToAllowSpawns(state, level, pos, player, hand);
        return interactionResult != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION ? interactionResult : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public static ItemInteractionResult tryToAllowSpawns(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (stack.getItem() == Items.HONEYCOMB && !((Boolean)state.getValue((Property)CoreStateProperties.Spawnable)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            BlockState spawnableBlockState = (BlockState)state.setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(true));
            stack.shrink(player.isCreative() ? 0 : 1);
            level.setBlock(pos, spawnableBlockState, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)spawnableBlockState));
            level.levelEvent(player, 3003, pos, 0);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public static IBlockCapabilityProvider<IColorable, Void> dyeColorCap(final EnumMap<DyeColors, BlockContent> map) {
        return (level, pos, state, blockEntity, context) -> new IColorable(){

            @Override
            public int getColor(int index) {
                Block block = state.getBlock();
                if (block instanceof ColoredBlock) {
                    ColoredBlock block2 = (ColoredBlock)block;
                    return block2.ColorSource.getColor();
                }
                return -1;
            }

            @Override
            @NotNull
            public IColorable.Result setColor(int index, int value) {
                DyeColors dyeColor = ColorUtils.getClosestDyeColor(value, DyeColors.White);
                Block newBlock = ((BlockContent)map.get(dyeColor)).block();
                if (newBlock != state.getBlock()) {
                    level.setBlockAndUpdate(pos, newBlock.withPropertiesOf(state));
                    return IColorable.Result.SUCCESS;
                }
                return IColorable.Result.DENIED;
            }
        };
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public int getColorOfItem(ItemStack stack, int index) {
        return index == -1 ? -1 : this.ColorSource.getColor();
    }
}

