/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;

public interface CoreItemDataComponents {
    public static final IRegister Instance = new IRegister(){

        @Override
        public void register(IEventBus bus) {
            Map.register(bus);
        }
    };
    public static final DeferredRegister.DataComponents Map = DeferredRegister.createDataComponents((String)"xycraft_core");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SimpleFluidContent>> FluidContainer = Map.registerComponentType("fluid_container", builder -> builder.persistent(CodecUtils.Codecs.FLUID_STACK_OPTIONAL.xmap(SimpleFluidContent::copyOf, SimpleFluidContent::copy)).networkSynchronized(SimpleFluidContent.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EnergyStored = Map.registerComponentType("energy_stored", builder -> builder.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> EnergyCapacity = Map.registerComponentType("energy_capacity", builder -> builder.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CustomData>> MissingContent = Map.registerComponentType("missing_content_itemstack_data", builder -> builder.persistent(CustomData.CODEC).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ComponentErrorData>> MissingContentError = Map.registerComponentType("missing_content_error", builder -> builder.persistent(ComponentErrorData.CODEC).networkSynchronized(ComponentErrorData.STREAM_CODEC));

    public record ComponentErrorData(String fullError, String simple) {
        public static final Codec<ComponentErrorData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("full").forGetter(ComponentErrorData::fullError), (App)Codec.STRING.fieldOf("simple").forGetter(ComponentErrorData::simple)).apply((Applicative)builder, ComponentErrorData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ComponentErrorData> STREAM_CODEC = BinarySerializer.ofType(ComponentErrorData::new, ComponentErrorData::fullError, Serializer.STRING, ComponentErrorData::simple, Serializer.STRING).asStreamCodec();
    }
}

