/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector.base;

import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlockEntity;
import com.mrh0.createaddition.blocks.connector.base.ConnectorMode;
import com.mrh0.createaddition.blocks.connector.base.ConnectorVariant;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConnectorBlock<BE extends AbstractConnectorBlockEntity>
extends Block
implements IBE<BE>,
IWrenchable,
TransformableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<ConnectorMode> MODE = EnumProperty.create((String)"mode", ConnectorMode.class);
    public static final EnumProperty<ConnectorVariant> VARIANT = EnumProperty.create((String)"variant", ConnectorVariant.class);
    private static final VoxelShape boxwe = Block.box((double)0.0, (double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0);
    private static final VoxelShape boxsn = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)10.0);

    public AbstractConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(MODE, (Comparable)((Object)ConnectorMode.None))).setValue(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE))).setValue(VARIANT, (Comparable)((Object)ConnectorVariant.Default)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODE, NodeRotation.ROTATION, VARIANT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext c) {
        Direction dir = c.getClickedFace().getOpposite();
        ConnectorMode mode = ConnectorMode.test(c.getLevel(), c.getClickedPos().relative(dir), c.getClickedFace());
        ConnectorVariant variant = ConnectorVariant.test(c.getLevel(), c.getClickedPos().relative(dir), c.getClickedFace());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue(MODE, (Comparable)((Object)mode))).setValue(VARIANT, (Comparable)((Object)variant));
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (level.isClientSide()) {
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(level, !player.isCreative());
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext c) {
        if (c.getLevel().isClientSide()) {
            c.getLevel().playLocalSound((double)c.getClickedPos().getX(), (double)c.getClickedPos().getY(), (double)c.getClickedPos().getZ(), SoundEvents.BONE_BLOCK_HIT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        c.getLevel().setBlockAndUpdate(c.getClickedPos(), (BlockState)state.setValue(MODE, (Comparable)((Object)((ConnectorMode)((Object)state.getValue(MODE))).getNext())));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext c) {
        BlockEntity be = c.getLevel().getBlockEntity(c.getClickedPos());
        if (be == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(be instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cbe = (IWireNode)be;
        if (!c.getLevel().isClientSide() && c.getPlayer() != null) {
            cbe.dropWires(c.getLevel(), c.getPlayer(), !c.getPlayer().isCreative());
        }
        return super.onSneakWrenched(state, c);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = state.hasBlockEntity() ? worldIn.getBlockEntity(pos) : null;
        if (blockEntity != null && blockEntity instanceof AbstractConnectorBlockEntity) {
            ((AbstractConnectorBlockEntity)blockEntity).updateExternalEnergyStorage();
        }
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            AbstractConnectorBlock.dropResources((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)blockEntity);
            if (blockEntity instanceof IWireNode) {
                ((IWireNode)blockEntity).dropWires(worldIn, true);
            }
            worldIn.removeBlock(pos, false);
            for (Direction direction : Direction.values()) {
                worldIn.updateNeighborsAt(pos.relative(direction), (Block)this);
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return !Shapes.joinIsNotEmpty((VoxelShape)world.getBlockState(pos.relative(dir)).getBlockSupportShape((BlockGetter)world, pos.relative(dir)).getFaceShape(dir.getOpposite()), (VoxelShape)boxwe, (BooleanOp)BooleanOp.ONLY_SECOND) || !Shapes.joinIsNotEmpty((VoxelShape)world.getBlockState(pos.relative(dir)).getBlockSupportShape((BlockGetter)world, pos.relative(dir)).getFaceShape(dir.getOpposite()), (VoxelShape)boxsn, (BooleanOp)BooleanOp.ONLY_SECOND) || world.getBlockState(pos.relative(dir)).isFaceSturdy((BlockGetter)world, pos, dir.getOpposite(), SupportType.CENTER) || (Boolean)CommonConfig.CONNECTOR_IGNORE_FACE_CHECK.get() != false;
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.rotate(state, direction);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        NodeRotation rotation = NodeRotation.get(transform.rotationAxis, transform.rotation);
        if (transform.mirror != null) {
            state = this.mirror(state, transform.mirror);
        }
        state = (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING), false));
        return (BlockState)state.setValue(NodeRotation.ROTATION, (Comparable)((Object)rotation));
    }
}

