/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.CommonConfig;
import com.mrh0.createaddition.energy.AbstractElectricBlockEntity;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CADamageTypes;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.index.CALang;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.index.CASounds;
import com.mrh0.createaddition.network.IObserveBlockEntity;
import com.mrh0.createaddition.network.ObservePacketPayload;
import com.mrh0.createaddition.network.TimeRemainingPacketPayload;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class TeslaCoilBlockEntity
extends AbstractElectricBlockEntity
implements IHaveGoggleInformation,
IObserveBlockEntity {
    private Optional<RecipeHolder<ChargingRecipe>> recipeCache = Optional.empty();
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    protected int poweredTimer = 0;
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;
    int zapTimer = 200;
    private int energyRemoved = 0;

    public TeslaCoilBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)CABlockEntities.TESLA_COIL.get(), (be, context) -> be.localEnergy);
    }

    @Override
    public int getCapacity() {
        return Util.max((Integer)CommonConfig.TESLA_COIL_CAPACITY.get(), (Integer)CommonConfig.TESLA_COIL_CHARGE_RATE.get(), (Integer)CommonConfig.TESLA_COIL_RECIPE_CHARGE_RATE.get());
    }

    @Override
    public int getMaxIn() {
        return (Integer)CommonConfig.TESLA_COIL_MAX_INPUT.get();
    }

    @Override
    public int getMaxOut() {
        return 0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != ((Direction)this.getBlockState().getValue((Property)TeslaCoilBlock.FACING)).getOpposite();
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public int getConsumption() {
        return (Integer)CommonConfig.TESLA_COIL_CHARGE_RATE.get();
    }

    protected float getItemCharge(IEnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        return this.chargeCompoundAndStack(transported, handler);
    }

    private void doDmg() {
        this.localEnergy.internalConsumeEnergy((Integer)CommonConfig.TESLA_COIL_HURT_ENERGY_REQUIRED.get());
        BlockPos origin = this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)TeslaCoilBlock.FACING)).getOpposite());
        List ents = this.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(origin).inflate((double)((Integer)CommonConfig.TESLA_COIL_HURT_RANGE.get()).intValue()));
        boolean zapped = false;
        for (LivingEntity e : ents) {
            if (e == null) {
                return;
            }
            boolean allChain = true;
            for (ItemStack armor : e.getArmorSlots()) {
                if (armor.is(Items.CHAINMAIL_BOOTS) || armor.is(Items.CHAINMAIL_LEGGINGS) || armor.is(Items.CHAINMAIL_CHESTPLATE) || armor.is(Items.CHAINMAIL_HELMET)) continue;
                allChain = false;
                break;
            }
            if (allChain) continue;
            int dmg = (Integer)CommonConfig.TESLA_COIL_HURT_DMG_MOB.get();
            int time = (Integer)CommonConfig.TESLA_COIL_HURT_EFFECT_TIME_MOB.get();
            if (e instanceof Player) {
                dmg = (Integer)CommonConfig.TESLA_COIL_HURT_DMG_PLAYER.get();
                time = (Integer)CommonConfig.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get();
            }
            if (dmg > 0) {
                e.hurt(CADamageTypes.teslaCoil(this.level), (float)dmg);
                if (!zapped) {
                    if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
                        this.level.playSound(null, this.worldPosition, (SoundEvent)CASounds.LOUD_ZAP.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                    }
                    zapped = true;
                }
            }
            if (time <= 0) continue;
            e.addEffect(new MobEffectInstance(CAEffects.SHOCKING, time));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::tickAudio);
            return;
        }
        int signal = this.level.getBestNeighborSignal(this.getBlockPos());
        if (signal > 0 && this.localEnergy.getEnergyStored() >= (Integer)CommonConfig.TESLA_COIL_HURT_ENERGY_REQUIRED.get()) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        if ((this.dmgTick %= ((Integer)CommonConfig.TESLA_COIL_HURT_FIRE_COOLDOWN.get()).intValue()) == 0 && this.localEnergy.getEnergyStored() >= (Integer)CommonConfig.TESLA_COIL_HURT_ENERGY_REQUIRED.get() && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (this.zapTimer == 0) {
                if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
                    this.level.playSound(null, this.worldPosition, (SoundEvent)CASounds.LITTLE_ZAP.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
                this.zapTimer = this.level.random.nextInt(100, 300);
            }
            --this.zapTimer;
            if (!this.isPoweredState()) {
                ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.level, this.getBlockPos(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.level, this.getBlockPos(), false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        if (!this.isPoweredState()) {
            return;
        }
        if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.TESLA, this.worldPosition, 1.0f);
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.getBlockState().getValue((Property)TeslaCoilBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompoundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.chargeStack(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected boolean chargeStack(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        IEnergyStorage es = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (es == null) {
            return false;
        }
        if (es.receiveEnergy(1, true) != 1) {
            return false;
        }
        if (this.localEnergy.getEnergyStored() < stack.getCount()) {
            return false;
        }
        this.localEnergy.internalConsumeEnergy(es.receiveEnergy(Math.min(this.getConsumption(), this.localEnergy.getEnergyStored()), false));
        return true;
    }

    private boolean chargeRecipe(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.getLevel() == null) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).is(stack.getItem())) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandler)this.inputInv), this.getLevel());
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = (ChargingRecipe)this.recipeCache.get().value();
            this.energyRemoved = this.localEnergy.internalConsumeEnergy(Util.min((Integer)CommonConfig.TESLA_COIL_RECIPE_CHARGE_RATE.get(), recipe.getEnergy() - this.chargeAccumulator, recipe.getMaxChargeRate()));
            this.chargeAccumulator += this.energyRemoved;
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack remainingStack = transported.copy();
                TransportedItemStack result = transported.copy();
                result.stack = recipe.getResultItem((HolderLookup.Provider)this.getLevel().registryAccess()).copy();
                remainingStack.stack.shrink(1);
                ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
                outList.add(result);
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remainingStack));
                this.chargeAccumulator = 0;
                if (((Boolean)CommonConfig.AUDIO_ENABLED.get()).booleanValue()) {
                    this.level.playSound(null, this.worldPosition, (SoundEvent)CASounds.LITTLE_ZAP.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    public Optional<RecipeHolder<ChargingRecipe>> find(RecipeWrapper wrapper, Level level) {
        return level.getRecipeManager().getRecipeFor(CARecipes.CHARGING_TYPE.get(), (RecipeInput)wrapper, level);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.level == null) {
            return false;
        }
        ObservePacketPayload.send(this.worldPosition, 0);
        if (TimeRemainingPacketPayload.clientTimeRemaining <= 20) {
            return false;
        }
        CALang.builder().add(Component.translatable((String)"createaddition.tooltip.charging.info").withStyle(ChatFormatting.WHITE)).forGoggles(tooltip);
        CALang.builder().add(Component.literal((String)" ").append((Component)Component.translatable((String)"createaddition.tooltip.charging.time_remaining").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(" " + Util.formatTime(TimeRemainingPacketPayload.clientTimeRemaining))).withStyle(ChatFormatting.AQUA))).forGoggles(tooltip);
        return true;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacketPayload pkt) {
        int timeRemaining = 0;
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = (ChargingRecipe)this.recipeCache.get().value();
            int chargeRate = Util.min((Integer)CommonConfig.TESLA_COIL_RECIPE_CHARGE_RATE.get(), recipe.getEnergy() - this.chargeAccumulator, recipe.getMaxChargeRate());
            if (chargeRate == 0) {
                return;
            }
            timeRemaining = (recipe.getEnergy() - this.chargeAccumulator) / chargeRate;
        }
        TimeRemainingPacketPayload.send(timeRemaining, player);
    }
}

