/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.generators;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.formations.generators.StructureSetKey;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public abstract class FormationsStructureSetGenerator
extends ResourceGenerator {
    private static final ResourceAggregator<Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>>, Pair<Pair<StructureSetKey, String>, Pair<ResourceLocation, Integer>>> AGGREGATOR = new ResourceAggregator<Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>>, Pair<Pair<StructureSetKey, String>, Pair<ResourceLocation, Integer>>>(){
        static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

        public Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>> initialData() {
            return null;
        }

        public Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>> combine(Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>> data, Pair<Pair<StructureSetKey, String>, Pair<ResourceLocation, Integer>> newData) {
            if (data == null) {
                return Pair.of((Object)((Pair)newData.left()), new LinkedHashSet<Pair>(Collections.singleton((Pair)newData.right())));
            }
            if (!Objects.equals(data.left(), newData.left())) {
                throw new IllegalStateException();
            }
            ((Set)data.right()).add((Pair)newData.right());
            return data;
        }

        public void write(OutputStream stream, Pair<Pair<StructureSetKey, String>, Set<Pair<ResourceLocation, Integer>>> data) throws IOException {
            JsonObject placement = new JsonObject();
            placement.addProperty("type", "minecraft:random_spread");
            StructureSetKey key = (StructureSetKey)((Pair)data.left()).left();
            int salt = key.name().hashCode() ^ ((String)((Pair)data.left()).right()).hashCode();
            if (salt < 0) {
                salt = -salt;
            }
            placement.addProperty("salt", (Number)salt);
            placement.addProperty("spacing", (Number)key.spacing());
            placement.addProperty("separation", (Number)key.separation());
            JsonArray structures = new JsonArray(((Set)data.right()).size());
            for (Pair structure : (Set)data.right()) {
                JsonObject object = new JsonObject();
                object.addProperty("structure", ((ResourceLocation)structure.left()).toString());
                object.addProperty("weight", (Number)structure.right());
                structures.add((JsonElement)object);
            }
            JsonObject json = new JsonObject();
            json.add("placement", (JsonElement)placement);
            json.add("structures", (JsonElement)structures);
            try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
    };
    private final List<Pair<StructureSetKey, Pair<ResourceLocation, Integer>>> structures = new ArrayList<Pair<StructureSetKey, Pair<ResourceLocation, Integer>>>();

    public FormationsStructureSetGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public void save() {
        this.structures.forEach(pair -> this.cache.saveResource(ResourceType.DATA, AGGREGATOR, (Object)Pair.of((Object)Pair.of((Object)((StructureSetKey)pair.left()), (Object)this.modid), (Object)((Pair)pair.right())), this.modid, "worldgen/structure_set", ((StructureSetKey)pair.left()).name(), ".json"));
    }

    protected void addStructure(StructureSetKey key, ResourceLocation location, int weight) {
        this.structures.add((Pair<StructureSetKey, Pair<ResourceLocation, Integer>>)Pair.of((Object)key, (Object)Pair.of((Object)location, (Object)weight)));
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, this.modid, "worldgen/structure_set", key.name(), ".json");
    }
}

