/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.module.ModuleMisc;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class InfinityChargerTile
extends IndustrialMachineTile<InfinityChargerTile> {
    @Save
    private SidedInventoryComponent<InfinityChargerTile> chargingSlot = (SidedInventoryComponent)new SidedInventoryComponent("charging", 80, 40, 1, 0).setColor(DyeColor.BLUE).setSlotLimit(1).setInputFilter((stack, integer) -> stack.getCapability(Capabilities.EnergyStorage.ITEM) != null);

    public InfinityChargerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.INFINITY_CHARGER, blockPos, blockState);
        this.addInventory((InventoryComponent)this.chargingSlot);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, InfinityChargerTile blockEntity) {
        if (!this.chargingSlot.getStackInSlot(0).isEmpty() && ((RedstoneAction)this.getRedstoneManager().getAction()).canRun(this.getEnvironmentValue(false, null)) && this.getRedstoneManager().shouldWork()) {
            IEnergyStorage iEnergyStorage = (IEnergyStorage)this.chargingSlot.getStackInSlot(0).getCapability(Capabilities.EnergyStorage.ITEM);
            if (iEnergyStorage != null && this.getEnergyStorage() instanceof InfinityEnergyStorage) {
                if (iEnergyStorage instanceof InfinityEnergyStorage) {
                    long added = Math.min(Long.MAX_VALUE - ((InfinityEnergyStorage)iEnergyStorage).getLongEnergyStored(), Math.min(((InfinityEnergyStorage)this.getEnergyStorage()).getLongCapacity(), ((InfinityEnergyStorage)this.getEnergyStorage()).getLongEnergyStored()));
                    ((InfinityEnergyStorage)iEnergyStorage).setEnergyStored(((InfinityEnergyStorage)iEnergyStorage).getLongEnergyStored() + added);
                    ((InfinityEnergyStorage)this.getEnergyStorage()).setEnergyStored(((InfinityEnergyStorage)this.getEnergyStorage()).getLongEnergyStored() - added);
                    this.markForUpdate();
                } else {
                    int extracted = this.getEnergyStorage().getEnergyStored();
                    ((InfinityEnergyStorage)this.getEnergyStorage()).setEnergyStored(((InfinityEnergyStorage)this.getEnergyStorage()).getLongEnergyStored() - (long)iEnergyStorage.receiveEnergy(extracted, false));
                    this.markForUpdate();
                }
            }
            this.getRedstoneManager().finish();
        }
    }

    public InfinityChargerTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<InfinityChargerTile> createEnergyStorage() {
        return new InfinityEnergyStorage<InfinityChargerTile>(1000000000000L, 10, 20);
    }
}

