/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.transporter.filter;

import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.RegulatorFilter;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemFilter
extends RegulatorFilter<ItemStack, IItemHandler> {
    public ItemFilter(int locX, int locY, int sizeX, int sizeY, int smallMultiplier, int bigMultiplier, int maxAmount, String label) {
        super(locX, locY, sizeX, sizeY, smallMultiplier, bigMultiplier, maxAmount, label);
    }

    @Override
    public boolean matches(ItemStack stack, IItemHandler handler) {
        if (this.isEmpty()) {
            return !this.isWhitelisted();
        }
        for (IFilter.GhostSlot slot : this.getFilterSlots()) {
            if (!ItemStack.isSameItem((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            return this.isWhitelisted();
        }
        return !this.isWhitelisted();
    }

    @Override
    public int getExtractAmount(ItemStack stack, IItemHandler handler) {
        if (!this.matches(stack, handler)) {
            return 0;
        }
        if (this.isEmpty() || !this.isRegulated() || !this.isWhitelisted()) {
            return stack.getCount();
        }
        return Math.max(0, this.getStorageAmount(stack, handler) - this.getFilterAmount(stack));
    }

    @Override
    public int getInsertAmount(ItemStack stack, IItemHandler handler) {
        if (!this.matches(stack, handler)) {
            return 0;
        }
        if (this.isEmpty() || !this.isRegulated() || !this.isWhitelisted()) {
            return stack.getCount();
        }
        return Math.max(0, this.getFilterAmount(stack) - this.getStorageAmount(stack, handler));
    }

    @Override
    public int getFilterAmount(ItemStack stack) {
        int amount = 0;
        for (IFilter.GhostSlot slot : this.getFilterSlots()) {
            if (!ItemStack.isSameItem((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            if (!this.isRegulated()) {
                return 1;
            }
            amount += slot.getAmount();
        }
        return amount;
    }

    @Override
    public int getStorageAmount(ItemStack stack, @NotNull IItemHandler handler) {
        int amount = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!ItemStack.isSameItem((ItemStack)handler.getStackInSlot(i), (ItemStack)stack)) continue;
            amount += handler.getStackInSlot(i).getCount();
        }
        return amount;
    }
}

