/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.entity.InfinityNukeEntity;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemInfinityNuke
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityNuke(TitaniumTab group) {
        super("infinity_nuke", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    public static int getRadius(ItemStack stack) {
        int tier = ItemInfinityNuke.getSelectedTier(stack).getRadius() + 1;
        double fluidAmount = 1.0 + (double)((ItemInfinityNuke)ModuleTool.INFINITY_NUKE.get()).getFuelFromStack(stack) / 1000000.0 * 0.5;
        return (int)((1.0 + Math.ceil((double)(tier * tier * tier) / 2.0)) * fluidAmount);
    }

    public InteractionResult useOn(UseOnContext context) {
        InfinityNukeEntity entity = new InfinityNukeEntity(context.getLevel(), (LivingEntity)context.getPlayer(), context.getItemInHand().copy());
        BlockPos blockPos = context.getClickedPos().relative(context.getClickedFace());
        entity.absMoveTo((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        context.getPlayer().setItemInHand(context.getHand(), ItemStack.EMPTY);
        context.getLevel().addFreshEntity((Entity)entity);
        IndustrialForegoing.LOGGER.info(String.valueOf(context.getPlayer().getUUID()) + " (" + context.getPlayer().getDisplayName().toString() + ") placed an Infinity Nuke");
        return InteractionResult.SUCCESS;
    }

    @Override
    public String getFormattedArea(ItemStack stack, InfinityTier tier, int radius, boolean usesDepth) {
        return ItemInfinityNuke.getRadius(stack) + "r";
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_nuke", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TNT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TNT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TNT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TNT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHER_STAR)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.NETHER_STAR)})), new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }
}

