/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityTridentEntity;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.tab.TitaniumTab;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemInfinityTrident
extends ItemInfinity {
    private static String LOYALTY_NBT = "Loyalty";
    private static String RIPTIDE_NBT = "Riptide";
    private static String CHANNELING_NBT = "Channeling";
    private static int LOYALTY_MAX = 7;
    private static int RIPTIDE_MAX = 7;
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;

    public ItemInfinityTrident(TitaniumTab group) {
        super("infinity_trident", group, new Item.Properties().stacksTo(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        stack.set(IFAttachments.INFINITY_TRIDENT_LOYALTY, (Object)0);
        stack.set(IFAttachments.INFINITY_TRIDENT_RIPTIDE, (Object)0);
        stack.set(IFAttachments.INFINITY_TRIDENT_CHANNELING, (Object)false);
    }

    @Override
    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (!stack.has(IFAttachments.INFINITY_TRIDENT_LOYALTY)) {
            stack.set(IFAttachments.INFINITY_TRIDENT_LOYALTY, (Object)0);
        }
        if (!stack.has(IFAttachments.INFINITY_TRIDENT_RIPTIDE)) {
            stack.set(IFAttachments.INFINITY_TRIDENT_RIPTIDE, (Object)0);
        }
        if (!stack.has(IFAttachments.INFINITY_TRIDENT_CHANNELING)) {
            stack.set(IFAttachments.INFINITY_TRIDENT_CHANNELING, (Object)false);
        }
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 36000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (this.getCurrentRiptide(itemstack) > 0 && !playerIn.isShiftKeyDown()) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        if (!playerIn.isShiftKeyDown()) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.equals((Object)Enchantments.LOYALTY) || enchantment.equals((Object)Enchantments.RIPTIDE) || enchantment.equals((Object)Enchantments.CHANNELING)) {
            return false;
        }
        return Items.TRIDENT.supportsEnchantment(new ItemStack((ItemLike)Items.TRIDENT), enchantment);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            int i = this.getUseDuration(stack, entityLiving) - timeLeft;
            if (i >= 10) {
                int riptideModifier = this.getCurrentRiptide(stack);
                if (riptideModifier <= 0 && this.enoughFuel(stack) && !worldIn.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)playerentity, EquipmentSlot.MAINHAND);
                    if (riptideModifier == 0) {
                        this.consumeFuel(stack);
                        InfinityTridentEntity tridententity = new InfinityTridentEntity(worldIn, (LivingEntity)playerentity, stack);
                        tridententity.shootFromRotation((Entity)playerentity, playerentity.getXRot(), playerentity.getYRot(), 0.0f, 2.5f + (float)((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft())).getRadius(), 0.0f);
                        if (playerentity.getAbilities().instabuild) {
                            tridententity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.addFreshEntity((Entity)tridententity);
                        worldIn.playSound((Player)null, tridententity.getX(), tridententity.getY(), tridententity.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!playerentity.getAbilities().instabuild) {
                            playerentity.getInventory().removeItem(stack);
                        }
                    }
                }
                playerentity.awardStat(Stats.ITEM_USED.get((Object)this));
                if (riptideModifier > 0 && this.enoughFuel(stack)) {
                    float f7 = playerentity.getYRot();
                    float f = playerentity.getXRot();
                    float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)riptideModifier * 2.0f) / 4.0f);
                    playerentity.push((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    playerentity.startAutoSpinAttack(20, (float)(((double)(8 + riptideModifier) + Math.pow(2.0, ItemInfinityTrident.getSelectedTier(stack).getRadius())) * 0.5), stack);
                    if (playerentity.onGround()) {
                        playerentity.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = riptideModifier >= 3 ? (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_3.value() : (riptideModifier == 2 ? (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_2.value() : (SoundEvent)SoundEvents.TRIDENT_RIPTIDE_1.value());
                    worldIn.playSound((Player)null, (Entity)playerentity, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.consumeFuel(stack);
                }
            }
        }
    }

    public int getCurrentLoyalty(ItemStack stack) {
        return (Integer)stack.getOrDefault(IFAttachments.INFINITY_TRIDENT_LOYALTY, (Object)0);
    }

    public int getMaxLoyalty(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius()), LOYALTY_MAX);
    }

    public void setLoyalty(ItemStack stack, int level) {
        stack.set(IFAttachments.INFINITY_TRIDENT_LOYALTY, (Object)level);
    }

    public int getCurrentRiptide(ItemStack stack) {
        return (Integer)stack.getOrDefault(IFAttachments.INFINITY_TRIDENT_RIPTIDE, (Object)0);
    }

    public int getMaxRiptide(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius()), RIPTIDE_MAX);
    }

    public void setRiptide(ItemStack stack, int level) {
        stack.set(IFAttachments.INFINITY_TRIDENT_RIPTIDE, (Object)level);
    }

    public boolean getCurrentChanneling(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IFAttachments.INFINITY_TRIDENT_CHANNELING, (Object)false);
    }

    public boolean canChanneling(ItemStack stack) {
        return ((InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityTrident.getPowerFromStack(stack)).getLeft())).getRadius() >= 4;
    }

    public void setChanneling(ItemStack stack, boolean enabled) {
        stack.set(IFAttachments.INFINITY_TRIDENT_CHANNELING, (Object)enabled);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"enchantment.minecraft.loyalty").append(": ").append(ItemInfinityTrident.this.getCurrentLoyalty((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxLoyalty((ItemStack)stack.get())).getString();
            }
        }));
        int y = 16;
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52 + y, 14, 14, FacingUtil.Sideness.RIGHT).setId(6))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52 + y, 14, 14, FacingUtil.Sideness.LEFT).setId(7))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56 + y, false){

            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"enchantment.minecraft.riptide").append(": ").append(ItemInfinityTrident.this.getCurrentRiptide((ItemStack)stack.get()) + "/" + ItemInfinityTrident.this.getMaxRiptide((ItemStack)stack.get())).getString();
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(54, 52 + y * 2, 14, 14).setId(8), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[0]), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[0])}){

            public int getState() {
                return ItemInfinityTrident.this.getCurrentChanneling((ItemStack)stack.get()) ? 0 : 1;
            }
        }));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon(String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"enchantment.minecraft.channeling").getString(), 72, 56 + y * 2, false)));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
        int current = this.getCurrentLoyalty(stack);
        int max = this.getMaxLoyalty(stack);
        if (id == 5 && current > 0) {
            this.setLoyalty(stack, Math.max(current - 1, 0));
        }
        if (id == 4 && current < max) {
            this.setRiptide(stack, 0);
            this.setLoyalty(stack, Math.min(max, current + 1));
        }
        current = this.getCurrentRiptide(stack);
        max = this.getMaxRiptide(stack);
        if (id == 7 && current > 0) {
            this.setRiptide(stack, Math.max(current - 1, 0));
        }
        if (id == 6 && current < max) {
            this.setLoyalty(stack, 0);
            this.setRiptide(stack, Math.min(max, current + 1));
        }
        if (id == 8 && this.canChanneling(stack)) {
            this.setChanneling(stack, !this.getCurrentChanneling(stack));
        }
    }

    @Override
    public void registerRecipe(RecipeOutput consumer) {
        DissolutionChamberRecipe.createRecipe(consumer, "infinity_trident", new DissolutionChamberRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TRIDENT)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_BLOCK)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.DIAMOND_HOE)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())}), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD), Ingredient.of(IndustrialTags.Items.GEAR_GOLD)), new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, Optional.of(new ItemStack((ItemLike)this)), Optional.empty()));
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        this.addTooltip(tooltip, "enchantment.minecraft.loyalty", this.getCurrentLoyalty(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.riptide", this.getCurrentRiptide(stack));
        this.addTooltip(tooltip, "enchantment.minecraft.channeling", this.getCurrentChanneling(stack) ? 1 : 0);
    }

    private void addTooltip(List<Component> tooltip, String type, int value) {
        if (value > 0) {
            String level = "0";
            switch (value) {
                case 1: {
                    level = "I";
                    break;
                }
                case 2: {
                    level = "II";
                    break;
                }
                case 3: {
                    level = "III";
                    break;
                }
                case 4: {
                    level = "IV";
                    break;
                }
                case 5: {
                    level = "V";
                    break;
                }
                case 6: {
                    level = "VI";
                    break;
                }
                case 7: {
                    level = "VII";
                }
            }
            tooltip.add((Component)Component.translatable((String)type).append(" " + level).withStyle(ChatFormatting.GRAY));
        }
    }
}

