/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidConveyorTESR
implements BlockEntityRenderer<ConveyorTile> {
    public static RenderType createRenderType(ResourceLocation texture) {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(GameRenderer::getPositionTexColorShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.disableCull();
        }, () -> RenderSystem.disableBlend())).createCompositeState(true);
        return RenderType.create((String)"conveyor_fluid", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)32, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    public FluidConveyorTESR(BlockEntityRendererProvider.Context p_173540_) {
    }

    public void render(ConveyorTile te, float p_225616_2_, PoseStack matrixStack, MultiBufferSource typeBuffer, int p_225616_5_, int p_225616_6_) {
        if (te.getTank().getFluidAmount() > 0) {
            AbstractTexture texture;
            int x = te.getBlockPos().getX();
            int y = te.getBlockPos().getY();
            int z = te.getBlockPos().getZ();
            matrixStack.pushPose();
            Direction facing = te.getFacing();
            if (facing == Direction.NORTH) {
                matrixStack.translate(1.0f, 0.0f, 1.0f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            if (facing == Direction.EAST) {
                matrixStack.translate(0.0f, 0.0f, 1.0f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            if (facing == Direction.WEST) {
                matrixStack.translate(1.0f, 0.0f, 0.0f);
                matrixStack.mulPose(Axis.YN.rotationDegrees(90.0f));
            }
            if ((texture = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas) {
                boolean shouldRenderNext;
                boolean shouldRenderPrev;
                FluidStack fluid = te.getTank().getFluid();
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                TextureAtlasSprite flow = ((TextureAtlas)texture).getSprite(renderProperties.getFlowingTexture(fluid));
                TextureAtlasSprite still = ((TextureAtlas)texture).getSprite(renderProperties.getStillTexture(fluid));
                float posY = 0.09375f;
                float right = 0.0625f;
                float left = 0.9375f;
                VertexConsumer buffer = typeBuffer.getBuffer(FluidConveyorTESR.createRenderType(ResourceLocation.fromNamespaceAndPath((String)flow.contents().name().getNamespace(), (String)("textures/" + flow.contents().name().getPath() + ".png"))));
                ConveyorBlock.EnumSides sides = ConveyorBlock.EnumSides.NONE;
                if (sides == ConveyorBlock.EnumSides.BOTH || sides == ConveyorBlock.EnumSides.RIGHT) {
                    right = 0.0f;
                }
                if (sides == ConveyorBlock.EnumSides.BOTH || sides == ConveyorBlock.EnumSides.LEFT) {
                    left = 1.0f;
                }
                Color color = new Color(renderProperties.getTintColor(te.getTank().getFluid()));
                matrixStack.pushPose();
                Matrix4f matrix = matrixStack.last().pose();
                float animation = 16.0f * flow.uvShrinkRatio() * (float)(te.getLevel().getGameTime() % flow.contents().getUniqueFrames().count());
                buffer.addVertex(matrix, left, posY, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 0.0f + animation);
                buffer.addVertex(matrix, right, posY, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.5f, 0.0f + animation);
                buffer.addVertex(matrix, right, posY, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.5f, 16.0f / (float)((long)flow.contents().height() * flow.contents().getUniqueFrames().count()) + animation);
                buffer.addVertex(matrix, left, posY, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 16.0f / (float)((long)flow.contents().height() * flow.contents().getUniqueFrames().count()) + animation);
                buffer = typeBuffer.getBuffer(FluidConveyorTESR.createRenderType(ResourceLocation.fromNamespaceAndPath((String)still.contents().name().getNamespace(), (String)("textures/" + still.contents().name().getPath() + ".png"))));
                animation = still.uvShrinkRatio() * (float)(te.getLevel().getGameTime() % (still.contents().getUniqueFrames().count() * 16L));
                boolean bl = shouldRenderPrev = !(te.getLevel().getBlockEntity(te.getBlockPos().relative(facing.getOpposite())) instanceof ConveyorTile) || ((ConveyorTile)te.getLevel().getBlockEntity(te.getBlockPos().relative(facing.getOpposite()))).getTank().getFluidAmount() <= 0;
                if (shouldRenderPrev) {
                    buffer.addVertex(matrix, right, posY, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 1.0f - 1.0f / (float)((long)still.contents().height() * still.contents().getUniqueFrames().count()) - animation);
                    buffer.addVertex(matrix, left, posY, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f - 1.0f / (float)((long)still.contents().height() * still.contents().getUniqueFrames().count()) - animation);
                    buffer.addVertex(matrix, left, 0.0625f, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f - animation);
                    buffer.addVertex(matrix, right, 0.0625f, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 1.0f - animation);
                }
                boolean bl2 = shouldRenderNext = !(te.getLevel().getBlockEntity(te.getBlockPos().relative(facing)) instanceof ConveyorTile) || ((ConveyorTile)te.getLevel().getBlockEntity(te.getBlockPos().relative(facing))).getTank().getFluidAmount() <= 0;
                if (shouldRenderNext) {
                    buffer.addVertex(matrix, left, posY, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f - 1.0f / (float)((long)still.contents().height() * still.contents().getUniqueFrames().count()) - animation);
                    buffer.addVertex(matrix, right, posY, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 1.0f - 1.0f / (float)((long)still.contents().height() * still.contents().getUniqueFrames().count()) - animation);
                    buffer.addVertex(matrix, right, 0.0625f, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(0.0f, 1.0f - animation);
                    buffer.addVertex(matrix, left, 0.0625f, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv(1.0f, 1.0f - animation);
                }
                matrixStack.popPose();
            }
            matrixStack.popPose();
        }
    }
}

