/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.IndustrialForegoing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockUtils {
    public static BiPredicate<Level, BlockPos> CLAIMED_CHUNK_CHECKER = (world, pos) -> true;

    public static List<BlockPos> getBlockPosInAABB(AABB axisAlignedBB) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (double y = axisAlignedBB.minY; y < axisAlignedBB.maxY; y += 1.0) {
            for (double x = axisAlignedBB.minX; x < axisAlignedBB.maxX; x += 1.0) {
                for (double z = axisAlignedBB.minZ; z < axisAlignedBB.maxZ; z += 1.0) {
                    blocks.add(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
        return blocks;
    }

    public static boolean isBlockTag(Level world, BlockPos pos, TagKey<Block> tag) {
        return BlockUtils.isBlockStateTag(world.getBlockState(pos), tag);
    }

    public static boolean isBlockStateTag(BlockState state, TagKey<Block> tag) {
        return state.is(tag);
    }

    public static boolean isLog(Level world, BlockPos pos) {
        return BlockUtils.isBlockTag(world, pos, (TagKey<Block>)BlockTags.LOGS) || world.getBlockState(pos).is(Blocks.MANGROVE_ROOTS);
    }

    public static boolean isLeaves(Level world, BlockPos pos) {
        return world.getBlockState(pos).is(BlockTags.WART_BLOCKS) || world.getBlockState(pos).is(BlockTags.LEAVES) || world.getBlockState(pos).getBlock().equals(Blocks.SHROOMLIGHT) || world.getBlockState(pos).getBlock().equals(Blocks.MOSS_CARPET) || world.getBlockState(pos).getBlock().equals(Blocks.MANGROVE_PROPAGULE) && (Boolean)world.getBlockState(pos).getValue((Property)MangrovePropaguleBlock.HANGING) != false;
    }

    public static boolean isChorus(Level world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().equals(Blocks.CHORUS_PLANT) || world.getBlockState(pos).getBlock().equals(Blocks.CHORUS_FLOWER);
    }

    public static boolean canBlockBeBroken(Level world, BlockPos pos, String uuid) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), (Player)IndustrialForegoing.getFakePlayer(world, pos, uuid));
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static boolean canBlockBeBrokenPlugin(Level world, BlockPos pos) {
        return CLAIMED_CHUNK_CHECKER.test(world, pos);
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos) {
        return BlockUtils.getBlockDrops(world, pos, 0);
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos pos, int fortune) {
        BlockState state = world.getBlockState(pos);
        NonNullList stacks = NonNullList.create();
        stacks.addAll((Collection)Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos)));
        return stacks;
    }

    public static boolean spawnItemStack(ItemStack stack, Level world, BlockPos pos) {
        ItemEntity item = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.2, (double)pos.getZ() + 0.5, stack);
        item.setDeltaMovement(0.0, -1.0, 0.0);
        item.setPickUpDelay(40);
        item.setItem(stack);
        return world.addFreshEntity((Entity)item);
    }

    public static void renderLaserBeam(BlockEntity tile, double x, double y, double z, Direction direction, float partialTicks, int length) {
    }
}

