/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridInsertionHint;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceRendering;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import com.refinedmods.refinedstorage.mekanism.content.Menus;
import com.refinedmods.refinedstorage.mekanism.grid.ChemicalGridInsertionHint;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public final class ClientModInitializer {
    private ClientModInitializer() {
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        RefinedStorageClientApi.INSTANCE.registerResourceRendering(ChemicalResource.class, (ResourceRendering)new ChemicalResourceRendering());
        RefinedStorageClientApi.INSTANCE.addAlternativeGridInsertionHint((GridInsertionHint)new ChemicalGridInsertionHint());
        ResourceLocation diskModel = MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier("block/disk/chemical_disk");
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            RefinedStorageClientApi.INSTANCE.registerDiskModel(Items.getChemicalStorageDisk(variant), diskModel);
        }
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        e.register(Menus.getChemicalStorage(), (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<AbstractContainerMenu, AbstractContainerScreen<AbstractContainerMenu>>(){

            public AbstractContainerScreen<AbstractContainerMenu> create(AbstractContainerMenu menu, Inventory inventory, Component title) {
                return RefinedStorageClientApi.INSTANCE.createStorageBlockScreen(menu, inventory, title, ChemicalResource.class);
            }
        });
    }
}

