/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.externalstorage.ExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipe;
import com.refinedmods.refinedstorage.common.storage.StorageContainerUpgradeRecipeSerializer;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.support.SimpleItem;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceFactory;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import com.refinedmods.refinedstorage.mekanism.ClientModInitializer;
import com.refinedmods.refinedstorage.mekanism.Config;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.ResourceContainerChemicalHandlerAdapter;
import com.refinedmods.refinedstorage.mekanism.autocrafting.ChemicalPatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.mekanism.content.BlockEntities;
import com.refinedmods.refinedstorage.mekanism.content.Blocks;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import com.refinedmods.refinedstorage.mekanism.content.Menus;
import com.refinedmods.refinedstorage.mekanism.exporter.ChemicalExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.mekanism.externalstorage.ChemicalPlatformExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.mekanism.grid.ChemicalGridExtractionStrategy;
import com.refinedmods.refinedstorage.mekanism.grid.ChemicalGridInsertionStrategy;
import com.refinedmods.refinedstorage.mekanism.grid.ChemicalGridResourceRepositoryMapper;
import com.refinedmods.refinedstorage.mekanism.importer.ChemicalImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.mekanism.recipemod.EmiChemicalResourceModIngredientConverter;
import com.refinedmods.refinedstorage.mekanism.recipemod.JeiChemicalRecipeModIngredientConverter;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageBlockBlockItem;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageBlockProvider;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageDiskItem;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import com.refinedmods.refinedstorage.mekanism.storagemonitor.ChemicalStorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="refinedstorage_mekanism_integration")
public final class ModInitializer {
    private static final ResourceLocation CHEMICAL_ID = MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier("chemical");
    private static final Config CONFIG = new Config();

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG.getSpec());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCreativeModeTabListener);
        eventBus.addListener(this::registerCapabilities);
        DeferredRegister itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"refinedstorage_mekanism_integration");
        ModInitializer.registerItems((DeferredRegister<Item>)itemRegistry);
        itemRegistry.register(eventBus);
        DeferredRegister blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"refinedstorage_mekanism_integration");
        ModInitializer.registerBlocks((DeferredRegister<Block>)blockRegistry);
        blockRegistry.register(eventBus);
        DeferredRegister blockEntityRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"refinedstorage_mekanism_integration");
        ModInitializer.registerBlockEntities(blockEntityRegistry);
        blockEntityRegistry.register(eventBus);
        DeferredRegister menuRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"refinedstorage_mekanism_integration");
        ExtendedMenuTypeFactory extendedMenuTypeFactory = new ExtendedMenuTypeFactory(this){

            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        };
        ModInitializer.registerMenus(menuRegistry, extendedMenuTypeFactory);
        menuRegistry.register(eventBus);
        DeferredRegister recipeSerializerRegistry = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"refinedstorage_mekanism_integration");
        ModInitializer.registerRecipeSerializers(recipeSerializerRegistry);
        recipeSerializerRegistry.register(eventBus);
    }

    private static void registerBlocks(DeferredRegister<Block> registry) {
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            Blocks.setChemicalStorageBlock(variant, (Supplier<Block>)registry.register(variant.getStorageBlockId().getPath(), () -> RefinedStorageApi.INSTANCE.createStorageBlock(BlockConstants.PROPERTIES, (StorageBlockProvider)new ChemicalStorageBlockProvider(variant))));
        }
    }

    private static void registerItems(DeferredRegister<Item> registry) {
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            if (variant.getStoragePartId() != null) {
                Items.setChemicalStoragePart(variant, (Supplier<Item>)registry.register(variant.getStoragePartId().getPath(), SimpleItem::new));
            }
            Items.setChemicalStorageDisk(variant, (Supplier<Item>)registry.register(variant.getStorageDiskId().getPath(), () -> new ChemicalStorageDiskItem(RefinedStorageApi.INSTANCE.getStorageContainerItemHelper(), variant)));
            Items.setChemicalStorageBlock(variant, (Supplier<Item>)registry.register(variant.getStorageBlockId().getPath(), () -> new ChemicalStorageBlockBlockItem(Blocks.getChemicalStorageBlock(variant), variant)));
        }
    }

    private static void registerBlockEntities(DeferredRegister<BlockEntityType<?>> blockEntityRegistry) {
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            BlockEntities.setChemicalStorageBlock(variant, blockEntityRegistry.register(variant.getStorageBlockId().getPath(), () -> new BlockEntityType((pos, state) -> RefinedStorageApi.INSTANCE.createStorageBlockEntity(pos, state, (StorageBlockProvider)new ChemicalStorageBlockProvider(variant)), Set.of(Blocks.getChemicalStorageBlock(variant)), null)));
        }
    }

    private static void registerMenus(DeferredRegister<MenuType<?>> menuRegistry, ExtendedMenuTypeFactory extendedMenuTypeFactory) {
        Menus.setChemicalStorage((Supplier<MenuType<AbstractContainerMenu>>)menuRegistry.register("chemical_storage_block", () -> extendedMenuTypeFactory.create((syncId, playerInventory, data) -> RefinedStorageApi.INSTANCE.createStorageBlockContainerMenu(syncId, playerInventory.player, data, (ResourceFactory)ChemicalResourceFactory.INSTANCE, Menus.getChemicalStorage()), RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec())));
    }

    private static void registerRecipeSerializers(DeferredRegister<RecipeSerializer<?>> registry) {
        registry.register("chemical_storage_disk_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ChemicalStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ChemicalStorageVariant.values(), (StorageVariant)to, Items::getChemicalStorageDisk)));
        registry.register("chemical_storage_block_upgrade", () -> new StorageContainerUpgradeRecipeSerializer((Enum[])ChemicalStorageVariant.values(), to -> new StorageContainerUpgradeRecipe((StorageVariant[])ChemicalStorageVariant.values(), (StorageVariant)to, Items::getChemicalStorageBlock)));
    }

    private void setup(FMLCommonSetupEvent e) {
        RefinedStorageApi.INSTANCE.getResourceTypeRegistry().register(CHEMICAL_ID, (Object)ChemicalResourceType.INSTANCE);
        RefinedStorageApi.INSTANCE.getAlternativeResourceFactories().add(ChemicalResourceFactory.INSTANCE);
        RefinedStorageApi.INSTANCE.getStorageTypeRegistry().register(CHEMICAL_ID, (Object)ChemicalResourceType.STORAGE_TYPE);
        RefinedStorageApi.INSTANCE.addGridResourceRepositoryMapper(ChemicalResource.class, (ResourceRepositoryMapper)new ChemicalGridResourceRepositoryMapper());
        RefinedStorageApi.INSTANCE.addGridInsertionStrategyFactory(ChemicalGridInsertionStrategy::new);
        RefinedStorageApi.INSTANCE.addGridExtractionStrategyFactory(ChemicalGridExtractionStrategy::new);
        RefinedStorageApi.INSTANCE.addStorageMonitorInsertionStrategy((StorageMonitorInsertionStrategy)new ChemicalStorageMonitorInsertionStrategy());
        RefinedStorageApi.INSTANCE.addResourceContainerInsertStrategy((ResourceContainerInsertStrategy)new ChemicalResourceContainerInsertStrategy());
        RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().register(CHEMICAL_ID, (Object)new ChemicalImporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().register(CHEMICAL_ID, (Object)new ChemicalExporterTransferStrategyFactory());
        RefinedStorageApi.INSTANCE.addExternalStorageProviderFactory((ExternalStorageProviderFactory)new ChemicalPlatformExternalStorageProviderFactory());
        RefinedStorageApi.INSTANCE.addPatternProviderExternalPatternSinkFactory((PatternProviderExternalPatternSinkFactory)new ChemicalPatternProviderExternalPatternSinkFactory());
        if (ModList.get().isLoaded("emi")) {
            RefinedStorageApi.INSTANCE.addIngredientConverter((RecipeModIngredientConverter)new EmiChemicalResourceModIngredientConverter());
        } else if (ModList.get().isLoaded("jei")) {
            RefinedStorageApi.INSTANCE.addIngredientConverter((RecipeModIngredientConverter)new JeiChemicalRecipeModIngredientConverter());
        }
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        if (!e.getTabKey().equals(creativeModeTab)) {
            return;
        }
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            if (variant.getStoragePartId() == null) continue;
            e.accept((ItemLike)Items.getChemicalStoragePart(variant));
        }
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            e.accept((ItemLike)Items.getChemicalStorageDisk(variant));
        }
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            e.accept((ItemLike)Items.getChemicalStorageBlock(variant));
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (ChemicalStorageVariant variant : ChemicalStorageVariant.values()) {
            event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), BlockEntities.getChemicalStorageBlock(variant), (be, side) -> be.getContainerProvider());
        }
        event.registerBlockEntity(ChemicalUtil.BLOCK_CAPABILITY, com.refinedmods.refinedstorage.common.content.BlockEntities.INSTANCE.getInterface(), (be, side) -> new ResourceContainerChemicalHandlerAdapter((ResourceContainer)be.getExportedResources()));
    }

    public static Config getConfig() {
        return CONFIG;
    }
}

