/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix;

import dev.satherov.crystalix.config.ConfigLoader;
import dev.satherov.crystalix.core.CSRegistry;
import lombok.Generated;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod(value="crystalix")
@EventBusSubscriber(modid="crystalix")
public class Crystalix {
    public static final String MOD_ID = "crystalix";
    private static Crystalix instance;
    private final ConfigLoader loader = ConfigLoader.create();

    public Crystalix(IEventBus bus, FMLModContainer container) {
        if (instance != null) {
            throw new IllegalStateException("Already initialized");
        }
        instance = this;
        this.loader.discover(container);
        CSRegistry.register(bus);
    }

    @SubscribeEvent
    private static void opInDev(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer entity = (ServerPlayer)player;
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            ServerLevel level = entity.serverLevel();
            MinecraftServer server = level.getServer();
            server.getPlayerList().op(entity.getGameProfile());
        }
    }

    @SubscribeEvent
    private static void onConfigLoad(ModConfigEvent.Loading event) {
        Crystalix.getInstance().getLoader().update(event.getConfig().getSpec());
    }

    @SubscribeEvent
    private static void onConfigReload(ModConfigEvent.Reloading event) {
        Crystalix.getInstance().getLoader().update(event.getConfig().getSpec());
    }

    @SubscribeEvent
    private static void registerAliases(FMLLoadCompleteEvent event) {
        CSRegistry.ENTRIES.cellSet().forEach(cell -> {
            String name = ((CSRegistry.Colors)cell.getColumnKey()).key();
            if (name.equals("peach") || name.equals("aquamarine") || name.equals("fluorescent") || name.equals("mint") || name.equals("maroon") || name.equals("bubblegum") || name.equals("lavender") || name.equals("persimmon") || name.equals("cherenkov") || name.equals("amber") || name.equals("honey") || name.equals("ultramarine") || name.equals("spring_green") || name.equals("rose") || name.equals("navy") || name.equals("icy_blue") || name.equals("wine") || name.equals("conifer")) {
                if (((CSRegistry.Types)((Object)((Object)cell.getRowKey()))).equals((Object)CSRegistry.Types.GLASS)) {
                    BuiltInRegistries.ITEM.addAlias(Crystalix.dye(String.format("crystalix_%s_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                    BuiltInRegistries.BLOCK.addAlias(Crystalix.dye(String.format("crystalix_%s_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                }
                if (((CSRegistry.Types)((Object)((Object)cell.getRowKey()))).equals((Object)CSRegistry.Types.CLEAR)) {
                    BuiltInRegistries.ITEM.addAlias(Crystalix.dye(String.format("crystalix_%s_clear_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                    BuiltInRegistries.BLOCK.addAlias(Crystalix.dye(String.format("crystalix_%s_clear_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                }
                if (((CSRegistry.Types)((Object)((Object)cell.getRowKey()))).equals((Object)CSRegistry.Types.BORDERED)) {
                    BuiltInRegistries.ITEM.addAlias(Crystalix.dye(String.format("crystalix_%s_bordered_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                    BuiltInRegistries.BLOCK.addAlias(Crystalix.dye(String.format("crystalix_%s_bordered_crystalix_glass", name)), ((DeferredHolder)cell.getValue()).getId());
                }
            }
        });
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private static ResourceLocation dye(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"dyenamicsandfriends", (String)path);
    }

    @Generated
    public static Crystalix getInstance() {
        return instance;
    }

    @Generated
    public ConfigLoader getLoader() {
        return this.loader;
    }
}

