/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.client.renderer;

import dev.satherov.crystalix.core.CSRegistry;
import dev.satherov.crystalix.core.network.CSNetwork;
import dev.satherov.crystalix.core.network.SetColorPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorPickerScreen
extends Screen {
    private static final int CELL_SIZE = 18;
    private static final int PADDING = 4;
    private static final int BORDER = 1;
    private static final int COLUMNS = 12;
    private transient boolean mouseDown = false;

    public ColorPickerScreen() {
        super((Component)Component.literal((String)"Color Picker"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int gridWidth() {
        return 260;
    }

    private int gridHeight() {
        int rows = (int)Math.ceil((double)CSRegistry.Colors.values().length / 12.0);
        return rows * 18 + (rows - 1) * 4;
    }

    public void render(@NotNull GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -2013265920);
        int gw = this.gridWidth();
        int gh = this.gridHeight();
        int x0 = (this.width - gw) / 2;
        int y0 = (this.height - gh) / 2;
        g.fill(x0 - 6, y0 - 6, x0 + gw + 6, y0 + gh + 6, -267053803);
        this.drawBorder(g, x0 - 6, y0 - 6, x0 + gw + 6, y0 + gh + 6, -1);
        CSRegistry.Colors[] colors = CSRegistry.Colors.values();
        int hovered = this.indexAt(mouseX, mouseY, x0, y0);
        for (int i = 0; i < colors.length; ++i) {
            int col = i % 12;
            int row = i / 12;
            int x = x0 + col * 22;
            int y = y0 + row * 22;
            int rgb = colors[i].color();
            if (rgb < 0) {
                this.drawChecker(g, x, y, 18, 18);
            }
            int fill = 0xFF000000 | (rgb < 0 ? 0xFFFFFF : rgb);
            g.fill(x + 1, y + 1, x + 18 - 1, y + 18 - 1, fill);
            if (i == hovered) {
                int overlay = this.mouseDown ? 0x44000000 : 0x22FFFFFF;
                g.fill(x + 1, y + 1, x + 18 - 1, y + 18 - 1, overlay);
            }
            this.drawBorder(g, x, y, x + 18, y + 18, -16777216);
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    private void drawBorder(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        g.fill(x1, y1, x2, y1 + 1, color);
        g.fill(x1, y2 - 1, x2, y2, color);
        g.fill(x1, y1, x1 + 1, y2, color);
        g.fill(x2 - 1, y1, x2, y2, color);
    }

    private void drawChecker(GuiGraphics g, int x, int y, int w, int h) {
        int s = 3;
        int c1 = -3355444;
        int c2 = -6710887;
        for (int yy = 0; yy < h; yy += s) {
            for (int xx = 0; xx < w; xx += s) {
                boolean alt = (xx / s + yy / s) % 2 == 0;
                g.fill(x + xx, y + yy, x + Math.min(xx + s, w), y + Math.min(yy + s, h), alt ? c1 : c2);
            }
        }
    }

    private int indexAt(int mouseX, int mouseY, int x0, int y0) {
        int gx = mouseX - x0;
        int gy = mouseY - y0;
        if (gx < 0 || gy < 0) {
            return -1;
        }
        int stride = 22;
        int col = gx / stride;
        int row = gy / stride;
        if (col >= 12) {
            return -1;
        }
        if (gx % stride >= 18 || gy % stride >= 18) {
            return -1;
        }
        int idx = row * 12 + col;
        return idx < CSRegistry.Colors.values().length ? idx : -1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mouseDown = true;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int gh;
        int y0;
        this.mouseDown = false;
        int gw = this.gridWidth();
        int x0 = (this.width - gw) / 2;
        int idx = this.indexAt((int)mouseX, (int)mouseY, x0, y0 = (this.height - (gh = this.gridHeight())) / 2);
        if (idx >= 0) {
            CSRegistry.Colors color = CSRegistry.Colors.values()[idx];
            CSNetwork.sendToServer(new SetColorPayload(color));
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

