/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.client.renderer;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.satherov.crystalix.client.KeybindManager;
import dev.satherov.crystalix.client.lang.CSLanguage;
import dev.satherov.crystalix.client.renderer.ColorPickerScreen;
import dev.satherov.crystalix.common.properties.CSProperties;
import dev.satherov.crystalix.common.properties.IProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RadialMenuScreen
extends Screen {
    private static final int INNER_RADIUS = 40;
    private static final int OUTER_RADIUS = 100;
    private static final int HOVER_EXTEND = 15;
    private static final int CENTER_DEAD_ZONE = 20;
    private final List<RadialMenuItem> menuItems = new ArrayList<RadialMenuItem>();
    private int hoveredIndex = -1;

    public RadialMenuScreen() {
        super((Component)Component.literal((String)"Radial Menu"));
    }

    public void addMenuItem(IProperty<?> property, Consumer<Boolean> action) {
        this.menuItems.add(new RadialMenuItem(property, action));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.drawRadialOverlay(graphics, centerX, centerY);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.hoveredIndex = this.getHoveredSection(mouseX, mouseY, centerX, centerY);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < this.menuItems.size(); ++i) {
            boolean isHovered = i == this.hoveredIndex;
            this.renderSection(graphics, mouseX, mouseY, centerX, centerY, i, this.menuItems.size(), isHovered, this.menuItems.get(i).property());
        }
        RenderSystem.disableBlend();
    }

    private void drawRadialOverlay(GuiGraphics graphics, int centerX, int centerY) {
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrix, (float)centerX, (float)centerY, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.0f);
        int segments = 64;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments);
            float x = (float)centerX + (float)Math.cos(angle);
            float y = (float)centerY + (float)Math.sin(angle);
            buffer.addVertex(matrix, x, y, 0.0f).setColor(0.0f, 0.0f, 0.0f, 0.6f);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void renderSection(GuiGraphics graphics, int mouseX, int mouseY, int centerX, int centerY, int index, int totalSections, boolean isHovered, IProperty<?> property) {
        float anglePerSection = 360.0f / (float)totalSections;
        float start = anglePerSection * (float)index - 90.0f;
        float midRad = (float)Math.toRadians(start + anglePerSection / 2.0f);
        this.drawLines(graphics, centerX, centerY, start);
        int outerRadius = isHovered ? 115 : 100;
        float labelRadius = (float)(40 + outerRadius) / 2.0f;
        int labelX = centerX + (int)(Math.cos(midRad) * (double)labelRadius);
        int labelY = centerY + (int)(Math.sin(midRad) * (double)labelRadius);
        int textColor = isHovered ? -1 : -3355444;
        int labelWidth = this.font.width((FormattedText)property.name());
        int valueWidth = this.font.width((FormattedText)property.display());
        graphics.drawString(this.font, (Component)property.name(), labelX - labelWidth / 2, labelY - 4, textColor);
        MutableComponent mutableComponent = property.display();
        int n = labelX - valueWidth / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)mutableComponent, n, labelY - 4 + 9, -1);
        if (!isHovered) {
            return;
        }
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(property.name().withStyle(ChatFormatting.DARK_GRAY));
        lines.add(CSLanguage.TOOLTIP_LMB.text(ChatFormatting.DARK_GRAY, ComponentUtils.wrapInSquareBrackets((Component)InputConstants.Type.MOUSE.getOrCreate(0).getDisplayName().copy().withStyle(ChatFormatting.GOLD)), ComponentUtils.wrapInSquareBrackets((Component)CSLanguage.INPUT_WHEEL_DOWN.text(ChatFormatting.GOLD))));
        lines.add(CSLanguage.TOOLTIP_RMB.text(ChatFormatting.DARK_GRAY, ComponentUtils.wrapInSquareBrackets((Component)InputConstants.Type.MOUSE.getOrCreate(1).getDisplayName().copy().withStyle(ChatFormatting.GOLD)), ComponentUtils.wrapInSquareBrackets((Component)CSLanguage.INPUT_WHEEL_UP.text(ChatFormatting.GOLD))));
        if (property.location().equals((Object)CSProperties.COLOR)) {
            lines.add(CSLanguage.TOOLTIP_MMB.text(ChatFormatting.DARK_GRAY, ComponentUtils.wrapInSquareBrackets((Component)InputConstants.Type.MOUSE.getOrCreate(2).getDisplayName().copy().withStyle(ChatFormatting.GOLD))));
        }
        graphics.renderComponentTooltip(this.font, lines, mouseX, mouseY);
    }

    private void drawLines(GuiGraphics graphics, float centerX, float centerY, float angle) {
        Matrix4f matrix = graphics.pose().last().pose();
        float r = 0.53f;
        float g = 0.53f;
        float b = 0.53f;
        float a = 1.0f;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        float rad = (float)Math.toRadians(angle);
        float x1 = centerX + (float)(Math.cos(rad) * 40.0);
        float y1 = centerY + (float)(Math.sin(rad) * 40.0);
        float x2 = centerX + (float)(Math.cos(rad) * 100.0);
        float y2 = centerY + (float)(Math.sin(rad) * 100.0);
        buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.lineWidth((float)1.5f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.lineWidth((float)1.0f);
    }

    private int getHoveredSection(int mouseX, int mouseY, int centerX, int centerY) {
        float dx = mouseX - centerX;
        float dy = mouseY - centerY;
        float distance = (float)Math.sqrt(dx * dx + dy * dy);
        if (distance < 20.0f || distance > 115.0f) {
            return -1;
        }
        float angle = (float)Math.toDegrees(Math.atan2(dy, dx)) + 90.0f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        float anglePerSection = 360.0f / (float)this.menuItems.size();
        int section = (int)(angle / anglePerSection);
        return section % this.menuItems.size();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hoveredIndex < 0 || this.hoveredIndex > this.menuItems.size()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 0 || button == 1) {
            RadialMenuItem item = this.menuItems.get(this.hoveredIndex);
            item.action().accept(button == 0);
            item.property().next(button == 0);
            return true;
        }
        if (button == 2 && this.menuItems.get(this.hoveredIndex).property().location().equals((Object)CSProperties.COLOR)) {
            Minecraft.getInstance().setScreen((Screen)new ColorPickerScreen());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mx, double my, double dx, double dy) {
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.menuItems.size()) {
            RadialMenuItem item = this.menuItems.get(this.hoveredIndex);
            item.action().accept(dy < 0.0);
            item.property().next(dy < 0.0);
            return true;
        }
        return super.mouseScrolled(mx, my, dx, dy);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (KeybindManager.SCREEN_OPENER.matches(keyCode, scanCode)) {
            this.onClose();
        }
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    private record RadialMenuItem(IProperty<?> property, Consumer<Boolean> action) {
    }
}

