/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.crystalix.data.providers;

import dev.satherov.crystalix.core.CSRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CSBlockModelProvider
extends BlockModelProvider {
    public CSBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crystalix", existingFileHelper);
    }

    protected void registerModels() {
        CSRegistry.ENTRIES.cellSet().forEach(cell -> {
            this.shadedBlock((DeferredHolder<Block, ? extends Block>)((DeferredHolder)cell.getValue()), (CSRegistry.Colors)cell.getColumnKey(), (CSRegistry.Types)((Object)((Object)cell.getRowKey())));
            this.shadelessBlock((DeferredHolder<Block, ? extends Block>)((DeferredHolder)cell.getValue()), (CSRegistry.Colors)cell.getColumnKey(), (CSRegistry.Types)((Object)((Object)cell.getRowKey())));
        });
    }

    private void shadedBlock(DeferredHolder<Block, ? extends Block> block, CSRegistry.Colors color, CSRegistry.Types type) {
        ((BlockModelBuilder)this.singleTexture("block/" + type.getSerializedName() + "/" + block.getId().getPath(), this.modLoc("block/block"), "all", this.modLoc("block/" + type.getSerializedName() + "/" + (color.color() < 0 ? color.key() : "color")))).renderType(RenderType.translucent().name);
    }

    private void shadelessBlock(DeferredHolder<Block, ? extends Block> block, CSRegistry.Colors color, CSRegistry.Types type) {
        ((BlockModelBuilder)this.singleTexture("block/" + type.getSerializedName() + "/" + block.getId().getPath() + "_no_shade", this.modLoc("block/no_shade_block"), "all", this.modLoc("block/" + type.getSerializedName() + "/" + (color.color() < 0 ? color.key() : "color")))).renderType(RenderType.translucent().name);
    }
}

