/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface WeatheringGolemSteel {
    public static final Supplier<ImmutableMap<Block, Block>> TO_OXIDIZED = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)ESBlocks.GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_BLOCK.get()).put((Object)((Block)ESBlocks.GOLEM_STEEL_SLAB.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_SLAB.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_STAIRS.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_STAIRS.get())).put((Object)ESBlocks.GOLEM_STEEL_TILES.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get()).put((Object)((Block)ESBlocks.GOLEM_STEEL_TILE_SLAB.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_SLAB.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_TILE_STAIRS.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_GRATE.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_GRATE.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_PILLAR.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_PILLAR.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_BARS.get()), (Object)((Block)ESBlocks.OXIDIZED_GOLEM_STEEL_BARS.get())).put((Object)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.OXIDIZED_CHISELED_GOLEM_STEEL_BLOCK.get()).put((Object)ESBlocks.GOLEM_STEEL_JET.get(), (Object)ESBlocks.OXIDIZED_GOLEM_STEEL_JET.get()).build());
    public static final Supplier<ImmutableMap<Block, Block>> TO_WAXED = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)ESBlocks.GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_BLOCK.get()).put((Object)((Block)ESBlocks.GOLEM_STEEL_SLAB.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_SLAB.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_STAIRS.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_STAIRS.get())).put((Object)ESBlocks.GOLEM_STEEL_TILES.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_TILES.get()).put((Object)((Block)ESBlocks.GOLEM_STEEL_TILE_SLAB.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_TILE_SLAB.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_TILE_STAIRS.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_TILE_STAIRS.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_GRATE.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_GRATE.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_PILLAR.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_PILLAR.get())).put((Object)((Block)ESBlocks.GOLEM_STEEL_BARS.get()), (Object)((Block)ESBlocks.WAXED_GOLEM_STEEL_BARS.get())).put((Object)ESBlocks.CHISELED_GOLEM_STEEL_BLOCK.get(), (Object)ESBlocks.WAXED_CHISELED_GOLEM_STEEL_BLOCK.get()).put((Object)ESBlocks.GOLEM_STEEL_JET.get(), (Object)ESBlocks.WAXED_GOLEM_STEEL_JET.get()).build());

    default public ItemInteractionResult use(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player) {
        Optional<Block> scraped = TO_OXIDIZED.get().entrySet().stream().filter(e -> e.getValue() == state.getBlock()).findFirst().map(Map.Entry::getKey);
        Optional<Block> unwaxed = TO_WAXED.get().entrySet().stream().filter(e -> e.getValue() == state.getBlock()).findFirst().map(Map.Entry::getKey);
        if (ESPlatform.INSTANCE.canScrape(stack)) {
            Block result = null;
            boolean waxSound = false;
            if (scraped.isPresent()) {
                result = scraped.get();
            } else if (unwaxed.isPresent()) {
                result = unwaxed.get();
                waxSound = true;
            }
            if (result != null) {
                level.setBlockAndUpdate(pos, result.withPropertiesOf(state));
                ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                player.playSound(waxSound ? SoundEvents.AXE_WAX_OFF : SoundEvents.AXE_SCRAPE);
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        Optional<BlockState> waxed = this.getWaxedState(state);
        if ((stack.is(Items.HONEYCOMB) || stack.is(ESItems.RAW_AMARAMBER.get())) && waxed.isPresent()) {
            level.setBlockAndUpdate(pos, waxed.get());
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)(stack.is(Items.HONEYCOMB) ? ParticleTypes.WAX_ON : (ParticleOptions)ESParticles.AMARAMBER_WAX_ON.get()), (IntProvider)UniformInt.of((int)3, (int)5));
            player.playSound(SoundEvents.HONEYCOMB_WAX_ON);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public boolean isOxidized() {
        WeatheringGolemSteel weatheringGolemSteel = this;
        if (weatheringGolemSteel instanceof Block) {
            Block block = (Block)weatheringGolemSteel;
            return TO_OXIDIZED.get().containsValue((Object)block);
        }
        return false;
    }

    default public boolean isWaxed() {
        WeatheringGolemSteel weatheringGolemSteel = this;
        if (weatheringGolemSteel instanceof Block) {
            Block block = (Block)weatheringGolemSteel;
            return TO_WAXED.get().containsValue((Object)block);
        }
        return false;
    }

    default public Optional<BlockState> getOxidizedState(BlockState blockState) {
        if (TO_OXIDIZED.get().containsKey((Object)blockState.getBlock())) {
            return Optional.ofNullable((Block)TO_OXIDIZED.get().get((Object)blockState.getBlock())).map(block -> block.withPropertiesOf(blockState));
        }
        return Optional.empty();
    }

    default public Optional<BlockState> getWaxedState(BlockState blockState) {
        if (TO_WAXED.get().containsKey((Object)blockState.getBlock())) {
            return Optional.ofNullable((Block)TO_WAXED.get().get((Object)blockState.getBlock())).map(block -> block.withPropertiesOf(blockState));
        }
        return Optional.empty();
    }

    default public void changeOverTime(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextFloat() < 0.05688889f) {
            this.getNextState(blockState, serverLevel, blockPos, randomSource).ifPresent(state -> serverLevel.setBlockAndUpdate(blockPos, state));
        }
    }

    default public Optional<BlockState> getNextState(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        BlockPos pos;
        int distManhattan;
        boolean oxidized = this.isOxidized();
        int lessAffected = 0;
        int moreAffected = 0;
        Iterator iterator = BlockPos.withinManhattan((BlockPos)blockPos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (distManhattan = (pos = (BlockPos)iterator.next()).distManhattan((Vec3i)blockPos)) <= 4) {
            Block block;
            if (pos.equals((Object)blockPos) || !((block = serverLevel.getBlockState(pos).getBlock()) instanceof WeatheringGolemSteel)) continue;
            WeatheringGolemSteel weatheringGolemSteel = (WeatheringGolemSteel)block;
            boolean otherBlockOxidized = weatheringGolemSteel.isOxidized();
            if (!otherBlockOxidized && oxidized) {
                return Optional.empty();
            }
            if (otherBlockOxidized && !oxidized) {
                ++moreAffected;
                continue;
            }
            ++lessAffected;
        }
        float oxidizeFactor = (float)(moreAffected + 1) / (float)(moreAffected + lessAffected + 1);
        return randomSource.nextFloat() < oxidizeFactor * oxidizeFactor * 0.75f ? this.getOxidizedState(blockState) : Optional.empty();
    }
}

