/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record PushTowardsEntity(LevelBasedValue minSpeed, LevelBasedValue maxSpeed) implements EnchantmentEntityEffect
{
    public static final MapCodec<PushTowardsEntity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("min_speed").forGetter(PushTowardsEntity::minSpeed), (App)LevelBasedValue.CODEC.fieldOf("max_speed").forGetter(PushTowardsEntity::maxSpeed)).apply((Applicative)instance, PushTowardsEntity::new));

    public void apply(ServerLevel serverLevel, int i, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 vec3) {
        if (enchantedItemInUse.owner() != null) {
            float speed = Math.max(0.0f, Mth.randomBetween((RandomSource)entity.getRandom(), (float)this.minSpeed.calculate(i), (float)this.maxSpeed.calculate(i)));
            Vec3 velocity = entity.position().subtract(enchantedItemInUse.owner().position()).normalize().scale((double)speed);
            enchantedItemInUse.owner().hurtMarked = true;
            enchantedItemInUse.owner().setDeltaMovement(enchantedItemInUse.owner().getDeltaMovement().add(velocity));
        }
    }

    public MapCodec<PushTowardsEntity> codec() {
        return CODEC;
    }
}

