/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherAmmoType;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ShotSeeds
extends ThrowableItemProjectile {
    private ItemStack firedFromWeapon;

    public ShotSeeds(EntityType<? extends ShotSeeds> entityType, Level level) {
        super(entityType, level);
    }

    public ShotSeeds(Level level, LivingEntity livingEntity, ItemStack stack, ItemStack weapon) {
        super(ESEntities.SHOT_SEEDS.get(), livingEntity, level);
        this.setItem(stack);
        if (weapon != null) {
            this.firedFromWeapon = weapon.copy();
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (weapon != null) {
                ShotSeeds.onProjectileSpawned(serverLevel, weapon, this, item -> {
                    this.firedFromWeapon = null;
                });
            }
        }
    }

    public ShotSeeds(Level level, double x, double y, double z) {
        super(ESEntities.SHOT_SEEDS.get(), x, y, z, level);
    }

    private static void onProjectileSpawned(ServerLevel serverLevel, ItemStack itemStack, ShotSeeds seeds, Consumer<Item> consumer) {
        LivingEntity livingEntity;
        Entity owner = seeds.getOwner();
        LivingEntity living = owner instanceof LivingEntity ? (livingEntity = (LivingEntity)owner) : null;
        EnchantedItemInUse enchantedItemInUse = new EnchantedItemInUse(itemStack, null, living, consumer);
        EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, i) -> ((Enchantment)holder.value()).onProjectileSpawned(serverLevel, i, enchantedItemInUse, (Entity)seeds));
    }

    public void tick() {
        super.tick();
        if (this.tickCount > (this.isOnFire() ? 40 : 80)) {
            this.discard();
        }
        if (this.isInWaterOrRain() || this.level().getBlockState(this.blockPosition()).is(Blocks.POWDER_SNOW)) {
            this.clearFire();
        }
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.discard();
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        Level level;
        super.onHitEntity(hitResult);
        Entity entity = hitResult.getEntity();
        Entity owner = this.getOwner();
        float damage = 0.5f;
        DamageSource source = ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.SEEDS, (Entity)this, owner);
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)source, (float)damage);
        }
        damage += (float)(this.getDeltaMovement().length() * 1.25);
        SeedsLauncherAmmoType type = (SeedsLauncherAmmoType)SeedsLauncherAmmoType.getAmmoType((HolderLookup.Provider)this.level().registryAccess(), this.getItem().getItem()).value();
        entity.invulnerableTime = 0;
        if (entity.hurt(source, damage *= type.damageMultiplier())) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)living, (DamageSource)source, (ItemStack)this.getWeaponItem());
                }
            }
            if (this.isOnFire()) {
                entity.igniteForSeconds((float)this.getRemainingFireTicks() / 20.0f / 15.0f);
            }
        }
    }

    protected Item getDefaultItem() {
        return Items.WHEAT_SEEDS;
    }
}

