/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.item.component.LargeItemStackList;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileWeaponItem.class})
public abstract class ProjectileWeaponItemMixin {
    @Inject(method={"createProjectile(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/entity/projectile/Projectile;"}, at={@At(value="RETURN")})
    private void createProjectile(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2, boolean bl, CallbackInfoReturnable<Projectile> cir) {
        Projectile projectile;
        if (itemStack.is(ESItems.STARFALL_LONGBOW.get())) {
            projectile = (Projectile)cir.getReturnValue();
            ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "eternal_starlight:starfall");
        }
        if (itemStack.is(ESItems.FLOWGLAZE_BOW.get())) {
            projectile = (Projectile)cir.getReturnValue();
            ESDataAttachments.ARROW_TYPE.setData((Entity)projectile, "eternal_starlight:flowglaze");
        }
        if (itemStack.is(ESItems.MOONRING_BOW.get()) && (projectile = (Projectile)cir.getReturnValue()) instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.setBaseDamage(arrow.getBaseDamage() + 0.75);
        }
    }

    @Inject(method={"getHeldProjectile(Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getHeldProjectile(LivingEntity livingEntity, Predicate<ItemStack> predicate, CallbackInfoReturnable<ItemStack> cir) {
        if (((ItemStack)cir.getReturnValue()).isEmpty() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack inventoryItem = inventory.getItem(i);
                if (!inventoryItem.is(ESItems.GALACTIC_QUIVER.get())) continue;
                List arrows = (List)inventoryItem.getOrDefault(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(List.of()));
                for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                    if (!predicate.test(arrowStack.getItem())) continue;
                    ItemStack ammo = arrowStack.getItem().copy();
                    ammo.set(ESDataComponents.QUIVER_ARROW.get(), (Object)Unit.INSTANCE);
                    cir.setReturnValue((Object)ammo);
                    return;
                }
            }
        }
    }

    @Inject(method={"useAmmo(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Z)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private static void useAmmo(ItemStack weapon, ItemStack ammo, LivingEntity shooter, boolean intangable, CallbackInfoReturnable<ItemStack> cir, @Local(ordinal=0) int ammoUse) {
        int use = ammoUse;
        ItemStack result = (ItemStack)cir.getReturnValue();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (result.has(ESDataComponents.QUIVER_ARROW.get()) && use > 0) {
                Inventory inventory = player.getInventory();
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack inventoryItem = inventory.getItem(i);
                    if (!inventoryItem.is(ESItems.GALACTIC_QUIVER.get())) continue;
                    ArrayList<LargeItemStackList.LargeItemStack> arrows = new ArrayList<LargeItemStackList.LargeItemStack>((Collection)inventoryItem.getOrDefault(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(List.of())));
                    for (LargeItemStackList.LargeItemStack arrowStack : arrows) {
                        ItemStack item = arrowStack.getItem().copy();
                        item.set(ESDataComponents.QUIVER_ARROW.get(), (Object)Unit.INSTANCE);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)result)) continue;
                        int shrink = Math.min(use, arrowStack.getCount());
                        arrowStack.shrink(shrink);
                        use -= shrink;
                    }
                    arrows.removeIf(LargeItemStackList.LargeItemStack::isEmpty);
                    inventoryItem.set(ESDataComponents.ARROWS.get(), (Object)new LargeItemStackList(Collections.unmodifiableList(arrows)));
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, inventoryItem));
                }
            }
        }
    }
}

