/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ScreenEffectRenderer.class})
public abstract class ScreenEffectRendererMixin {
    @Unique
    private static final Material ABYSSAL_FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, EternalStarlight.id("block/abyssal_fire_1"));

    @Inject(method={"renderScreenEffect(Lnet/minecraft/client/Minecraft;Lcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    private static void renderScreenEffect(Minecraft minecraft, PoseStack poseStack, CallbackInfo ci) {
        if (minecraft.player != null && !minecraft.player.isSpectator() && ESDataAttachments.IN_ABYSSAL_FIRE_TICKS.getData((Entity)minecraft.player) > 0) {
            ScreenEffectRendererMixin.renderAbyssalFlame(poseStack);
        }
    }

    @Unique
    private static void renderAbyssalFlame(PoseStack poseStack) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.depthFunc((int)519);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        TextureAtlasSprite textureAtlasSprite = ABYSSAL_FIRE_1.sprite();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureAtlasSprite.atlasLocation());
        float f = textureAtlasSprite.getU0();
        float g = textureAtlasSprite.getU1();
        float h = (f + g) / 2.0f;
        float i = textureAtlasSprite.getV0();
        float j = textureAtlasSprite.getV1();
        float k = (i + j) / 2.0f;
        float l = textureAtlasSprite.uvShrinkRatio();
        float m = Mth.lerp((float)l, (float)f, (float)h);
        float n = Mth.lerp((float)l, (float)g, (float)h);
        float o = Mth.lerp((float)l, (float)i, (float)k);
        float p = Mth.lerp((float)l, (float)j, (float)k);
        for (int r = 0; r < 2; ++r) {
            poseStack.pushPose();
            poseStack.translate((float)(-(r * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(r * 2 - 1) * 10.0f));
            Matrix4f matrix4f = poseStack.last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferBuilder.addVertex(matrix4f, -0.5f, -0.5f, -0.5f).setColor(1.0f, 1.0f, 1.0f, 0.9f).setUv(n, p);
            bufferBuilder.addVertex(matrix4f, 0.5f, -0.5f, -0.5f).setColor(1.0f, 1.0f, 1.0f, 0.9f).setUv(m, p);
            bufferBuilder.addVertex(matrix4f, 0.5f, 0.5f, -0.5f).setColor(1.0f, 1.0f, 1.0f, 0.9f).setUv(m, o);
            bufferBuilder.addVertex(matrix4f, -0.5f, 0.5f, -0.5f).setColor(1.0f, 1.0f, 1.0f, 0.9f).setUv(n, o);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
    }
}

